/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.bootstrap;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.server.meta.node.NodeService;
import com.alipay.sofa.registry.server.meta.remoting.connection.NodeConnectManager;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceFactory
implements ApplicationContextAware {
    private static Map<Node.NodeType, StoreService> storeServiceMap = new HashMap<Node.NodeType, StoreService>();
    private static Map<Node.NodeType, NodeConnectManager> connectManagerMap = new HashMap<Node.NodeType, NodeConnectManager>();
    private static Map<Node.NodeType, NodeService> nodeServiceMap = new HashMap<Node.NodeType, NodeService>();

    public static StoreService getStoreService(Node.NodeType nodeType) {
        return storeServiceMap.get(nodeType);
    }

    public static NodeService getNodeService(Node.NodeType nodeType) {
        return nodeServiceMap.get(nodeType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(StoreService.class);
        map.forEach((key, value) -> storeServiceMap.put(value.getNodeType(), (StoreService)value));
        Map managerMap = applicationContext.getBeansOfType(NodeConnectManager.class);
        managerMap.forEach((key, value) -> connectManagerMap.put(value.getNodeType(), (NodeConnectManager)value));
        Map nodeServiceBeanMap = applicationContext.getBeansOfType(NodeService.class);
        nodeServiceBeanMap.forEach((key, value) -> nodeServiceMap.put(value.getNodeType(), (NodeService)value));
    }
}

