/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.resource;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.metrics.ReporterUtils;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerBootstrap;
import com.alipay.sofa.registry.server.data.node.DataNodeStatus;
import com.alipay.sofa.registry.server.data.util.LocalServerStatusEnum;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="health")
public class HealthResource {
    @Autowired
    private DataServerBootstrap dataServerBootstrap;
    @Autowired
    private DataNodeStatus dataNodeStatus;

    @PostConstruct
    public void init() {
        MetricRegistry metrics = new MetricRegistry();
        metrics.register("healthCheck", (Metric)((Gauge)() -> this.getHealthCheckResult()));
        ReporterUtils.startSlf4jReporter((long)60L, (MetricRegistry)metrics);
    }

    @GET
    @Path(value="check")
    @Produces(value={"application/json"})
    public Response checkHealth() {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        CommonResponse response = this.getHealthCheckResult();
        builder.entity((Object)response);
        if (!response.isSuccess()) {
            builder.status(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return builder.build();
    }

    private CommonResponse getHealthCheckResult() {
        boolean start;
        StringBuilder sb = new StringBuilder("DataServerBoot ");
        boolean ret = start = this.dataServerBootstrap.getServerForSessionStarted().get();
        sb.append("severForSession:").append(start);
        start = this.dataServerBootstrap.getServerForDataSyncStarted().get();
        ret = ret && start;
        sb.append(", severForDataSync:").append(start);
        start = this.dataServerBootstrap.getHttpServerStarted().get();
        ret = ret && start;
        sb.append(", httpServer:").append(start);
        start = this.dataServerBootstrap.getSchedulerStarted().get();
        ret = ret && start;
        sb.append(", schedulerStarted:").append(start);
        start = this.dataNodeStatus.getStatus() == LocalServerStatusEnum.WORKING;
        ret = ret && start;
        sb.append(", status:").append((Object)this.dataNodeStatus.getStatus());
        CommonResponse response = ret ? CommonResponse.buildSuccessResponse((String)sb.toString()) : CommonResponse.buildFailedResponse((String)sb.toString());
        response = ret ? CommonResponse.buildSuccessResponse((String)sb.toString()) : CommonResponse.buildFailedResponse((String)sb.toString());
        return response;
    }
}

