/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.resource;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DataServerCache;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import com.alipay.sofa.registry.server.data.remoting.metaserver.MetaServerConnectionFactory;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.SessionServerConnectionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="digest")
public class DataDigestResource {
    private static final String SESSION = "SESSION";
    private static final String DATA = "DATA";
    private static final String META = "META";
    @Autowired
    private SessionServerConnectionFactory sessionServerConnectionFactory;
    @Autowired
    private MetaServerConnectionFactory metaServerConnectionFactory;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private DatumCache datumCache;
    @Autowired
    private DataServerCache dataServerCache;

    @GET
    @Path(value="datum/query")
    @Produces(value={"application/json"})
    public Map<String, Datum> getDatumByDataInfoId(@QueryParam(value="dataId") String dataId, @QueryParam(value="group") String group, @QueryParam(value="instanceId") String instanceId, @QueryParam(value="dataCenter") String dataCenter) {
        Map<String, Datum> retList = new HashMap<String, Datum>();
        if (!(this.isBlank(dataId) || this.isBlank(instanceId) || this.isBlank(group))) {
            String dataInfoId = DataInfo.toDataInfoId((String)dataId, (String)instanceId, (String)group);
            if (this.isBlank(dataCenter)) {
                retList = this.datumCache.get(dataInfoId);
            } else {
                retList.put(dataCenter, this.datumCache.get(dataCenter, dataInfoId));
            }
        }
        return retList;
    }

    @POST
    @Path(value="connect/query")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Publisher>> getPublishersByConnectId(Map<String, String> map) {
        HashMap<String, Map<String, Publisher>> ret = new HashMap<String, Map<String, Publisher>>();
        if (map != null && !map.isEmpty()) {
            map.forEach((ip, port) -> {
                Map<String, Publisher> publisherMap;
                String connectId = NetUtil.genHost((String)ip, (int)Integer.valueOf(port));
                if (!connectId.isEmpty() && (publisherMap = this.datumCache.getByConnectId(connectId)) != null && !publisherMap.isEmpty()) {
                    ret.put(connectId, publisherMap);
                }
            });
        }
        return ret;
    }

    @GET
    @Path(value="datum/count")
    @Produces(value={"application/json"})
    public String getDatumCount() {
        return this.getLocalDatumCount();
    }

    protected String getLocalDatumCount() {
        StringBuilder sb = new StringBuilder("CacheDigest");
        try {
            Map<String, Map<String, Datum>> allMap = this.datumCache.getAll();
            if (!allMap.isEmpty()) {
                for (Map.Entry<String, Map<String, Datum>> dataCenterEntry : allMap.entrySet()) {
                    String dataCenter = dataCenterEntry.getKey();
                    Map<String, Datum> datumMap = dataCenterEntry.getValue();
                    sb.append(String.format(" [Datum] size of datum in %s is %s", dataCenter, datumMap.size()));
                    int pubCount = datumMap.values().stream().map(Datum::getPubMap).filter(map -> map != null && !map.isEmpty()).mapToInt(Map::size).sum();
                    sb.append(String.format(",[Publisher] size of publisher in %s is %s", dataCenter, pubCount));
                }
            } else {
                sb.append(" datum cache is empty");
            }
        }
        catch (Throwable t) {
            sb.append(" cache digest error!");
        }
        return sb.toString();
    }

    @GET
    @Path(value="{type}/serverList/query")
    @Produces(value={"application/json"})
    public Map<String, List<String>> getServerListAll(@PathParam(value="type") String type) {
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        if (type != null && !type.isEmpty()) {
            String inputType;
            switch (inputType = type.toUpperCase()) {
                case "SESSION": {
                    List<String> sessionList = this.getSessionServerList();
                    if (sessionList == null) break;
                    map = new HashMap();
                    map.put(this.dataServerConfig.getLocalDataCenter(), sessionList);
                    break;
                }
                case "DATA": {
                    map = this.getDataServerList();
                    break;
                }
                case "META": {
                    map = this.getMetaServerList();
                    break;
                }
                default: {
                    map = new HashMap();
                }
            }
        }
        return map;
    }

    public List<String> getSessionServerList() {
        List<String> connections = this.sessionServerConnectionFactory.getSessionConnections().stream().filter(connection -> connection != null && connection.isFine()).map(connection -> connection.getRemoteIP() + ":" + connection.getRemotePort()).collect(Collectors.toList());
        return connections;
    }

    public Map<String, List<String>> getDataServerList() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        HashSet<String> allDataCenter = new HashSet<String>(this.dataServerCache.getAllDataCenters());
        for (String dataCenter : allDataCenter) {
            List list = map.computeIfAbsent(dataCenter, k -> new ArrayList());
            Map<String, DataServerNode> dataNodes = DataServerNodeFactory.getDataServerNodes(dataCenter);
            if (dataNodes == null || dataNodes.isEmpty()) continue;
            dataNodes.forEach((ip, dataServerNode) -> {
                Connection connection;
                if (ip != null && !ip.equals(DataServerConfig.IP) && (connection = dataServerNode.getConnection()) != null && connection.isFine()) {
                    list.add(connection.getRemoteIP());
                }
            });
        }
        return map;
    }

    public Map<String, List<String>> getMetaServerList() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        HashSet<String> allDataCenter = new HashSet<String>(this.metaServerConnectionFactory.getAllDataCenters());
        for (String dataCenter : allDataCenter) {
            List list = map.computeIfAbsent(dataCenter, k -> new ArrayList());
            Map<String, Connection> metaConnections = this.metaServerConnectionFactory.getConnections(dataCenter);
            if (metaConnections == null || metaConnections.isEmpty()) continue;
            metaConnections.forEach((ip, connection) -> {
                if (connection != null && connection.isFine()) {
                    list.add(connection.getRemoteIP());
                }
            });
        }
        return map;
    }

    private boolean isBlank(String dataInfoId) {
        return dataInfoId == null || dataInfoId.isEmpty();
    }
}

