/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.renew;

import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.event.AfterWorkingProcess;
import com.alipay.sofa.registry.server.data.node.DataNodeStatus;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.ClientDisconnectEvent;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectEventHandler;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatumLeaseManager
implements AfterWorkingProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatumLeaseManager.class);
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("Asia/Shanghai");
    private static final Logger RENEW_LOGGER = LoggerFactory.getLogger((String)"RENEW-LOGGER", (String)"[DatumLeaseManager]");
    private final Map<String, Long> connectIdRenewTimestampMap = new ConcurrentHashMap<String, Long>();
    private ConcurrentHashMap<String, Boolean> locksForConnectId = new ConcurrentHashMap();
    private volatile boolean serverWorking = false;
    private volatile boolean renewEnable = true;
    private AsyncHashedWheelTimer datumAsyncHashedWheelTimer;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private DisconnectEventHandler disconnectEventHandler;
    @Autowired
    private DatumCache datumCache;
    @Autowired
    private DataNodeStatus dataNodeStatus;
    private ScheduledThreadPoolExecutor executorForHeartbeatLess;
    private ScheduledFuture<?> futureForHeartbeatLess;

    @PostConstruct
    public void init() {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        this.datumAsyncHashedWheelTimer = new AsyncHashedWheelTimer(threadFactoryBuilder.setNameFormat("Registry-DatumLeaseManager-WheelTimer").build(), 100L, TimeUnit.MILLISECONDS, 1024, this.dataServerConfig.getDatumLeaseManagerExecutorThreadSize(), this.dataServerConfig.getDatumLeaseManagerExecutorQueueSize(), threadFactoryBuilder.setNameFormat("Registry-DatumLeaseManager-WheelExecutor-%d").build(), new AsyncHashedWheelTimer.TaskFailedCallback(){

            public void executionRejected(Throwable e) {
                LOGGER.error("executionRejected: " + e.getMessage(), e);
            }

            public void executionFailed(Throwable e) {
                LOGGER.error("executionFailed: " + e.getMessage(), e);
            }
        });
        this.executorForHeartbeatLess = new ScheduledThreadPoolExecutor(1, threadFactoryBuilder.setNameFormat("Registry-DatumLeaseManager-ExecutorForHeartbeatLess").build());
        this.scheduleEvictTaskForHeartbeatLess();
    }

    public synchronized void reset() {
        LOGGER.info("reset is called, EvictTaskForHeartbeatLess will delay {}s", (Object)this.dataServerConfig.getDatumTimeToLiveSec());
        if (this.futureForHeartbeatLess != null) {
            this.futureForHeartbeatLess.cancel(false);
        }
        this.scheduleEvictTaskForHeartbeatLess();
    }

    private void scheduleEvictTaskForHeartbeatLess() {
        this.futureForHeartbeatLess = this.executorForHeartbeatLess.scheduleWithFixedDelay(new EvictTaskForHeartbeatLess(), this.dataServerConfig.getDatumTimeToLiveSec(), this.dataServerConfig.getDatumTimeToLiveSec(), TimeUnit.SECONDS);
    }

    public void renew(String connectId) {
        if (RENEW_LOGGER.isDebugEnabled()) {
            RENEW_LOGGER.debug("renew: connectId={}", (Object)connectId);
        }
        this.connectIdRenewTimestampMap.put(connectId, System.currentTimeMillis());
        this.scheduleEvictTask(connectId, 0L);
    }

    public void remove(String connectId) {
        Long removed;
        if (RENEW_LOGGER.isDebugEnabled()) {
            RENEW_LOGGER.debug("remove: connectId={}", (Object)connectId);
        }
        if ((removed = this.connectIdRenewTimestampMap.remove(connectId)) != null) {
            LOGGER.info("remove connectId({}) because it is clientOff", (Object)connectId);
        }
    }

    private void scheduleEvictTask(String connectId, long delaySec) {
        delaySec = delaySec <= 0L ? (long)this.dataServerConfig.getDatumTimeToLiveSec() : delaySec;
        Boolean ifAbsent = this.locksForConnectId.putIfAbsent(connectId, true);
        if (ifAbsent != null) {
            return;
        }
        this.datumAsyncHashedWheelTimer.newTimeout(_timeout -> {
            boolean continued = true;
            long nextDelaySec = 0L;
            try {
                boolean isExpired;
                this.locksForConnectId.remove(connectId);
                Long lastRenewTime = this.connectIdRenewTimestampMap.get(connectId);
                if (lastRenewTime == null) {
                    LOGGER.info("EvictTask(connectId={}) stop because already disconnected", (Object)connectId);
                    return;
                }
                if (RENEW_LOGGER.isDebugEnabled()) {
                    RENEW_LOGGER.debug("EvictTask: connectId={}, lastRenewTime={}", (Object)connectId, (Object)this.format(lastRenewTime));
                }
                boolean bl = isExpired = System.currentTimeMillis() - lastRenewTime > (long)this.dataServerConfig.getDatumTimeToLiveSec() * 1000L;
                if (!this.isRenewEnable()) {
                    LOGGER.info("scheduleEvictTask({}) skipped because isRenewEnable() is false, lastRenewTime is {}, DataNodeStatus is {}, will retry after {}s", new Object[]{connectId, this.format(lastRenewTime), this.dataNodeStatus.getStatus(), this.dataServerConfig.getDatumTimeToLiveSec()});
                    nextDelaySec = this.dataServerConfig.getDatumTimeToLiveSec();
                } else if (isExpired) {
                    int ownPubSize = this.getOwnPubSize(connectId);
                    if (ownPubSize > 0) {
                        LOGGER.info("Evict connectId({}) because expired, lastRenewTime is {}, pub.size is {}", new Object[]{connectId, this.format(lastRenewTime), ownPubSize});
                        this.evict(connectId);
                    }
                    this.connectIdRenewTimestampMap.remove(connectId, lastRenewTime);
                    continued = false;
                } else {
                    nextDelaySec = (long)this.dataServerConfig.getDatumTimeToLiveSec() - (System.currentTimeMillis() - lastRenewTime) / 1000L;
                    nextDelaySec = nextDelaySec <= 0L ? 1L : nextDelaySec;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in task of datumAsyncHashedWheelTimer", (Throwable)e);
            }
            if (continued) {
                this.scheduleEvictTask(connectId, nextDelaySec);
            }
        }, delaySec, TimeUnit.SECONDS);
        if (RENEW_LOGGER.isDebugEnabled()) {
            RENEW_LOGGER.debug("scheduleEvictTask: connectId={}, delaySec={}", (Object)connectId, (Object)delaySec);
        }
    }

    private int getOwnPubSize(String connectId) {
        Map<String, Publisher> ownPubs = this.datumCache.getOwnByConnectId(connectId);
        return ownPubs != null ? ownPubs.size() : 0;
    }

    private void evict(String connectId) {
        this.disconnectEventHandler.receive(new ClientDisconnectEvent(connectId, System.currentTimeMillis(), 0));
    }

    private String format(long lastRenewTime) {
        return DateFormatUtils.format((long)lastRenewTime, (String)"yyyy-MM-dd HH:mm:ss", (TimeZone)TIME_ZONE);
    }

    @Override
    public void afterWorkingProcess() {
        this.executorForHeartbeatLess.schedule(() -> {
            this.serverWorking = true;
        }, (long)this.dataServerConfig.getRenewEnableDelaySec(), TimeUnit.SECONDS);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    public void setRenewEnable(boolean renewEnable) {
        this.renewEnable = renewEnable;
    }

    private boolean isRenewEnable() {
        return this.renewEnable && this.serverWorking;
    }

    private class EvictTaskForHeartbeatLess
    implements Runnable {
        private EvictTaskForHeartbeatLess() {
        }

        @Override
        public void run() {
            if (!DatumLeaseManager.this.isRenewEnable()) {
                LOGGER.info("EvictTaskForHeartbeatLess skipped because isRenewEnable() is false, DataNodeStatus is {}, will retry after {}s", (Object)DatumLeaseManager.this.dataNodeStatus.getStatus(), (Object)DatumLeaseManager.this.dataServerConfig.getDatumTimeToLiveSec());
                return;
            }
            Set<String> allConnectIds = DatumLeaseManager.this.datumCache.getAllConnectIds();
            for (String connectId : allConnectIds) {
                int ownPubSize;
                Long timestamp = (Long)DatumLeaseManager.this.connectIdRenewTimestampMap.get(connectId);
                if (timestamp != null || (ownPubSize = DatumLeaseManager.this.getOwnPubSize(connectId)) <= 0) continue;
                LOGGER.info("Evict connectId({}) because no heartbeat, pub.size is {}", (Object)connectId, (Object)ownPubSize);
                DatumLeaseManager.this.evict(connectId);
            }
            LOGGER.info("connectIdRenewTimestampMap.size is {}", (Object)DatumLeaseManager.this.connectIdRenewTimestampMap.size());
        }
    }
}

