/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.SessionServerRegisterRequest;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.SessionServerConnectionFactory;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionServerRegisterHandler
extends AbstractServerHandler<SessionServerRegisterRequest> {
    @Autowired
    private SessionServerConnectionFactory sessionServerConnectionFactory;

    @Override
    public void checkParam(SessionServerRegisterRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getProcessId(), (String)"processId");
    }

    @Override
    public Object doHandle(Channel channel, SessionServerRegisterRequest request) {
        HashSet<String> connectIds = request.getConnectIds();
        if (connectIds == null) {
            connectIds = new HashSet<String>();
        }
        this.sessionServerConnectionFactory.registerSession(request.getProcessId(), connectIds, ((BoltChannel)channel).getConnection());
        return CommonResponse.buildSuccessResponse();
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return SessionServerRegisterRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

