/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.PublisherDigestUtil;
import com.alipay.sofa.registry.common.model.RenewDatumRequest;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.event.AfterWorkingProcess;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.renew.DatumLeaseManager;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RenewDatumHandler
extends AbstractServerHandler<RenewDatumRequest>
implements AfterWorkingProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenewDatumHandler.class);
    private static final Logger RENEW_LOGGER = LoggerFactory.getLogger((String)"RENEW-LOGGER", (String)"[RenewDatumHandler]");
    private final AtomicBoolean renewEnabled = new AtomicBoolean(false);
    @Autowired
    private DatumLeaseManager datumLeaseManager;
    @Autowired
    private DatumCache datumCache;
    @Autowired
    private ThreadPoolExecutor renewDatumProcessorExecutor;
    @Autowired
    private DataServerConfig dataServerConfig;

    public Executor getExecutor() {
        return this.renewDatumProcessorExecutor;
    }

    @Override
    protected void logRequest(Channel channel, RenewDatumRequest request) {
    }

    @Override
    public void checkParam(RenewDatumRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getConnectId(), (String)"RenewDatumRequest.connectId");
        ParaCheckUtil.checkNotBlank((String)request.getDigestSum(), (String)"RenewDatumRequest.digestSum");
    }

    @Override
    public Object doHandle(Channel channel, RenewDatumRequest request) {
        if (RENEW_LOGGER.isDebugEnabled()) {
            RENEW_LOGGER.debug("doHandle: request={}", (Object)request);
        }
        if (!this.renewEnabled.get()) {
            LOGGER.warn("Renew request refused, renewEnabled is false, request: {}", (Object)request);
            GenericResponse response = new GenericResponse();
            response.setSuccess(false);
            response.setMessage("Renew request refused, renewEnabled is false yet");
            return response;
        }
        boolean theSame = this.renewDatum(request);
        return new GenericResponse().fillSucceed((Object)theSame);
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return RenewDatumRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }

    private boolean renewDatum(RenewDatumRequest request) {
        String connectId = WordCache.getInstance().getWordCache(request.getConnectId());
        String renewDigest = request.getDigestSum();
        Map<String, Publisher> publisherMap = this.datumCache.getOwnByConnectId(connectId);
        String cacheDigest = null;
        if (publisherMap != null && publisherMap.values().size() > 0) {
            cacheDigest = String.valueOf(PublisherDigestUtil.getDigestValueSum(publisherMap.values()));
        }
        this.datumLeaseManager.renew(connectId);
        boolean result = StringUtils.equals((String)renewDigest, cacheDigest);
        if (!result) {
            RENEW_LOGGER.info("Digest different! renewDatumRequest={}", (Object)request);
        }
        return result;
    }

    @Override
    public void afterWorkingProcess() {
        this.renewDatumProcessorExecutor.submit(() -> {
            try {
                TimeUnit.MILLISECONDS.sleep(this.dataServerConfig.getRenewEnableDelaySec());
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.renewEnabled.set(true);
        });
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

