/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.PublishType;
import com.alipay.sofa.registry.common.model.dataserver.PublishDataRequest;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.SessionServerConnectionFactory;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.forward.ForwardService;
import com.alipay.sofa.registry.server.data.renew.DatumLeaseManager;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishDataHandler
extends AbstractServerHandler<PublishDataRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishDataHandler.class);
    @Autowired
    private ForwardService forwardService;
    @Autowired
    private SessionServerConnectionFactory sessionServerConnectionFactory;
    @Autowired
    private DataChangeEventCenter dataChangeEventCenter;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private DatumLeaseManager datumLeaseManager;
    @Autowired
    private ThreadPoolExecutor publishProcessorExecutor;

    @Override
    public void checkParam(PublishDataRequest request) throws RuntimeException {
        Publisher publisher = request.getPublisher();
        ParaCheckUtil.checkNotNull((Object)publisher, (String)"PublishDataRequest.publisher");
        ParaCheckUtil.checkNotBlank((String)publisher.getDataId(), (String)"publisher.dataId");
        ParaCheckUtil.checkNotBlank((String)publisher.getInstanceId(), (String)"publisher.instanceId");
        ParaCheckUtil.checkNotBlank((String)publisher.getGroup(), (String)"publisher.group");
        ParaCheckUtil.checkNotBlank((String)publisher.getDataInfoId(), (String)"publisher.dataInfoId");
        ParaCheckUtil.checkNotNull((Object)publisher.getVersion(), (String)"publisher.version");
        ParaCheckUtil.checkNotBlank((String)publisher.getRegisterId(), (String)"publisher.registerId");
        if (publisher.getPublishType() != PublishType.TEMPORARY) {
            ParaCheckUtil.checkNotNull((Object)publisher.getSourceAddress(), (String)"publisher.sourceAddress");
        }
    }

    @Override
    public Object doHandle(Channel channel, PublishDataRequest request) {
        Publisher publisher = Publisher.internPublisher((Publisher)request.getPublisher());
        if (this.forwardService.needForward()) {
            LOGGER.warn("[forward] Publish request refused, request: {}", (Object)request);
            CommonResponse response = new CommonResponse();
            response.setSuccess(false);
            response.setMessage("Request refused, Server status is not working");
            return response;
        }
        this.dataChangeEventCenter.onChange(publisher, this.dataServerConfig.getLocalDataCenter());
        if (publisher.getPublishType() != PublishType.TEMPORARY) {
            String connectId = WordCache.getInstance().getWordCache(publisher.getSourceAddress().getAddressString());
            this.sessionServerConnectionFactory.registerConnectId(request.getSessionServerProcessId(), connectId);
            this.datumLeaseManager.renew(connectId);
        }
        return CommonResponse.buildSuccessResponse();
    }

    public CommonResponse buildFailedResponse(String msg) {
        return new CommonResponse(false, msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return PublishDataRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }

    public Executor getExecutor() {
        return this.publishProcessorExecutor;
    }
}

