/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.GetDataVersionRequest;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;

public class GetDataVersionsHandler
extends AbstractServerHandler<GetDataVersionRequest> {
    @Autowired
    private DatumCache datumCache;
    @Autowired
    private ThreadPoolExecutor getDataProcessorExecutor;

    public Executor getExecutor() {
        return this.getDataProcessorExecutor;
    }

    @Override
    protected void logRequest(Channel channel, GetDataVersionRequest request) {
    }

    @Override
    public void checkParam(GetDataVersionRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotEmpty((Collection)request.getDataInfoIds(), (String)"GetDataVersionRequest.dataInfoIds");
    }

    @Override
    public Object doHandle(Channel channel, GetDataVersionRequest request) {
        HashMap<String, HashMap<String, Long>> map = new HashMap<String, HashMap<String, Long>>();
        List dataInfoIds = request.getDataInfoIds();
        for (String dataInfoId : dataInfoIds) {
            Map<String, Long> datumMap = this.datumCache.getVersions(dataInfoId);
            Set<Map.Entry<String, Long>> entrySet = datumMap.entrySet();
            for (Map.Entry<String, Long> entry : entrySet) {
                String dataCenter = entry.getKey();
                Long version = entry.getValue();
                HashMap<String, Long> dataInfoIdToVersionMap = (HashMap<String, Long>)map.get(dataCenter);
                if (dataInfoIdToVersionMap == null) {
                    dataInfoIdToVersionMap = new HashMap<String, Long>(dataInfoIds.size());
                    map.put(dataCenter, dataInfoIdToVersionMap);
                }
                dataInfoIdToVersionMap.put(dataInfoId, version);
            }
        }
        return new GenericResponse().fillSucceed(map);
    }

    public GenericResponse<Map<String, Map<String, Long>>> buildFailedResponse(String msg) {
        return new GenericResponse().fillFailed(msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return GetDataVersionRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

