/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.GetDataRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.forward.ForwardService;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;

public class GetDataHandler
extends AbstractServerHandler<GetDataRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetDataHandler.class);
    @Autowired
    private ForwardService forwardService;
    @Autowired
    private DatumCache datumCache;
    @Autowired
    private ThreadPoolExecutor getDataProcessorExecutor;

    public Executor getExecutor() {
        return this.getDataProcessorExecutor;
    }

    @Override
    public void checkParam(GetDataRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getDataInfoId(), (String)"GetDataRequest.dataInfoId");
    }

    @Override
    public Object doHandle(Channel channel, GetDataRequest request) {
        String dataInfoId = request.getDataInfoId();
        if (this.forwardService.needForward()) {
            try {
                LOGGER.warn("[forward] Get data request forward, request: {}", (Object)request);
                return this.forwardService.forwardRequest(dataInfoId, request);
            }
            catch (Exception e) {
                LOGGER.error("[forward] getData request error, request: {}", (Object)request, (Object)e);
                GenericResponse response = new GenericResponse();
                response.setSuccess(false);
                response.setMessage(e.getMessage());
                return response;
            }
        }
        return new GenericResponse().fillSucceed(this.datumCache.getDatumGroupByDataCenter(request.getDataCenter(), dataInfoId));
    }

    public GenericResponse<Map<String, Datum>> buildFailedResponse(String msg) {
        return new GenericResponse().fillFailed(msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return GetDataRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

