/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.DatumSnapshotRequest;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.PublisherDigestUtil;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.change.event.DatumSnapshotEvent;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.renew.DatumLeaseManager;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;

public class DatumSnapshotHandler
extends AbstractServerHandler<DatumSnapshotRequest> {
    private static final Logger RENEW_LOGGER = LoggerFactory.getLogger((String)"RENEW-LOGGER", (String)"[DatumSnapshotHandler]");
    private static final int LIMITED_LIST_SIZE_FOR_PRINT = 10;
    @Autowired
    private DataChangeEventCenter dataChangeEventCenter;
    @Autowired
    private DatumLeaseManager datumLeaseManager;
    @Autowired
    private DatumCache datumCache;
    @Autowired
    private ThreadPoolExecutor renewDatumProcessorExecutor;

    public Executor getExecutor() {
        return this.renewDatumProcessorExecutor;
    }

    @Override
    public void checkParam(DatumSnapshotRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getConnectId(), (String)"DatumSnapshotRequest.connectId");
        ParaCheckUtil.checkNotEmpty((Collection)request.getPublishers(), (String)"DatumSnapshotRequest.publishers");
    }

    @Override
    public Object doHandle(Channel channel, DatumSnapshotRequest request) {
        RENEW_LOGGER.info("Received datumSnapshotRequest: {}", (Object)request);
        String connectId = WordCache.getInstance().getWordCache(request.getConnectId());
        HashMap<String, Publisher> pubMap = new HashMap<String, Publisher>();
        List publishers = request.getPublishers();
        if (publishers != null) {
            for (Publisher publisher : publishers) {
                Publisher.internPublisher((Publisher)publisher);
                pubMap.put(publisher.getRegisterId(), publisher);
            }
        }
        boolean isDiff = true;
        Map<String, Publisher> cachePubMap = this.datumCache.getOwnByConnectId(connectId);
        if (cachePubMap == null) {
            RENEW_LOGGER.info(">>>>>>> connectId={}, cachePubMap.size=0, pubMap.size={}, isDiff={}, the diff is: pubMap={}", new Object[]{connectId, pubMap.size(), isDiff, this.limitedToString(pubMap.values())});
        } else {
            List diffPub1 = this.subtract(pubMap, cachePubMap);
            List diffPub2 = this.subtract(cachePubMap, pubMap);
            if (diffPub1.size() == 0 && diffPub2.size() == 0) {
                isDiff = false;
            }
            RENEW_LOGGER.info(">>>>>>> connectId={}, cachePubMap.size={}, pubMap.size={}, isDiff={}, the diff is: pubMap-cachePubMap=(size:{}){}, cachePubMap-pubMap=(size:{}){}", new Object[]{connectId, cachePubMap.size(), pubMap.size(), isDiff, diffPub1.size(), this.limitedToString(diffPub1), diffPub2.size(), this.limitedToString(diffPub2)});
        }
        if (isDiff) {
            this.dataChangeEventCenter.onChange(new DatumSnapshotEvent(connectId, cachePubMap, pubMap));
        }
        this.datumLeaseManager.renew(connectId);
        return CommonResponse.buildSuccessResponse();
    }

    private String limitedToString(Collection<Publisher> publishers) {
        Iterator<Publisher> it = publishers.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 1;
        while (true) {
            Publisher e = it.next();
            sb.append("Publisher{dataInfoId='").append(e.getDataInfoId()).append('\'');
            sb.append(", cell='").append(e.getCell()).append('\'');
            sb.append(", registerId='").append(e.getRegisterId()).append('\'');
            sb.append(", version=").append(e.getVersion());
            sb.append(", sourceAddress=").append(e.getSourceAddress());
            sb.append(", registerTimestamp=").append(e.getRegisterTimestamp());
            sb.append(", clientRegisterTimestamp=").append(e.getClientRegisterTimestamp());
            sb.append('}');
            if (!it.hasNext() || i++ >= 10) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private List subtract(Map<String, Publisher> pubMap1, Map<String, Publisher> pubMap2) {
        ArrayList<Publisher> list = new ArrayList<Publisher>();
        for (Map.Entry<String, Publisher> entry : pubMap1.entrySet()) {
            String registerId = entry.getKey();
            Publisher publisher1 = entry.getValue();
            Publisher publisher2 = pubMap2.get(registerId);
            if (publisher2 != null && PublisherDigestUtil.getDigestValue((Publisher)publisher1) == PublisherDigestUtil.getDigestValue((Publisher)publisher2)) continue;
            list.add(publisher1);
        }
        return list;
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return DatumSnapshotRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

