/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.ClientOffRequest;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.ClientDisconnectEvent;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectEventHandler;
import com.alipay.sofa.registry.server.data.renew.DatumLeaseManager;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientOffHandler
extends AbstractServerHandler<ClientOffRequest> {
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private DisconnectEventHandler disconnectEventHandler;
    @Autowired
    private DatumLeaseManager datumLeaseManager;

    @Override
    public void checkParam(ClientOffRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotEmpty((Collection)request.getHosts(), (String)"ClientOffRequest.hosts");
    }

    @Override
    public Object doHandle(Channel channel, ClientOffRequest request) {
        List hosts = request.getHosts();
        for (String host : hosts) {
            this.datumLeaseManager.remove(host);
            this.disconnectEventHandler.receive(new ClientDisconnectEvent(host, request.getGmtOccur(), this.dataServerConfig.getClientOffDelayMs()));
        }
        return CommonResponse.buildSuccessResponse();
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return ClientOffRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

