/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.DisconnectEventHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.disconnect.SessionServerDisconnectEvent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionServerConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionServerConnectionFactory.class);
    private static final int DELAY = 30000;
    private static final Map EMPTY_MAP = new HashMap(0);
    private final Map<String, String> SESSION_CONN_PROCESS_ID_MAP = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> PROCESS_ID_CONNECT_ID_MAP = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Pair> PROCESS_ID_SESSION_CONN_MAP = new ConcurrentHashMap<String, Pair>();
    @Autowired
    private DisconnectEventHandler disconnectEventHandler;

    public void registerSession(String processId, Set<String> connectIds, Connection connection) {
        if (!connection.isFine()) {
            return;
        }
        String sessionConnAddress = NetUtil.toAddressString((InetSocketAddress)connection.getRemoteAddress());
        LOGGER.info("session({}, processId={}) registered", (Object)sessionConnAddress, (Object)processId);
        this.SESSION_CONN_PROCESS_ID_MAP.put(sessionConnAddress, processId);
        Set connectIdSet = this.PROCESS_ID_CONNECT_ID_MAP.computeIfAbsent(processId, k -> ConcurrentHashMap.newKeySet());
        connectIdSet.addAll(connectIds);
        Pair pair = this.PROCESS_ID_SESSION_CONN_MAP.computeIfAbsent(processId, k -> new Pair(new ConcurrentHashMap()));
        pair.getConnections().put(sessionConnAddress, connection);
    }

    public void registerConnectId(String processId, String connectId) {
        Set connectIdSet = this.PROCESS_ID_CONNECT_ID_MAP.computeIfAbsent(processId, k -> ConcurrentHashMap.newKeySet());
        connectIdSet.add(connectId);
    }

    public void sessionDisconnected(String sessionConnAddress) {
        String processId = this.SESSION_CONN_PROCESS_ID_MAP.remove(sessionConnAddress);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("session({}, processId={}) unregistered", (Object)sessionConnAddress, (Object)processId);
        }
        if (processId != null) {
            Pair pair = this.PROCESS_ID_SESSION_CONN_MAP.get(processId);
            if (pair != null) {
                pair.getConnections().remove(sessionConnAddress);
                pair.lastDisconnectedSession = sessionConnAddress;
            }
            if (pair == null || pair.getConnections().isEmpty()) {
                this.disconnectEventHandler.receive(new SessionServerDisconnectEvent(processId, sessionConnAddress, 30000));
            }
        }
    }

    public Set<String> removeConnectIds(String processId) {
        return this.PROCESS_ID_CONNECT_ID_MAP.remove(processId);
    }

    public boolean removeProcessIfMatch(String processId, String sessionConnAddress) {
        Pair emptyPair = new Pair(EMPTY_MAP);
        emptyPair.lastDisconnectedSession = sessionConnAddress;
        return this.PROCESS_ID_SESSION_CONN_MAP.remove(processId, emptyPair);
    }

    public List<Connection> getSessionConnections() {
        ArrayList<Connection> list = new ArrayList<Connection>(this.PROCESS_ID_SESSION_CONN_MAP.size());
        Collection<Pair> pairs = this.PROCESS_ID_SESSION_CONN_MAP.values();
        if (pairs != null) {
            for (Pair pair : pairs) {
                Object[] conns = pair.getConnections().values().toArray();
                if (conns.length <= 0) continue;
                int n = pair.roundRobin.incrementAndGet();
                if (n < 0) {
                    pair.roundRobin.compareAndSet(n, 0);
                    n = n == Integer.MIN_VALUE ? 0 : Math.abs(n);
                }
                list.add((Connection)conns[n %= conns.length]);
            }
        }
        return list;
    }

    private static class Pair {
        private AtomicInteger roundRobin = new AtomicInteger(-1);
        private Map<String, Connection> connections;
        private String lastDisconnectedSession;

        private Pair(Map<String, Connection> connections) {
            this.connections = connections;
        }

        public boolean equals(Object o) {
            return this.connections.equals(((Pair)o).getConnections()) && ((Pair)o).lastDisconnectedSession.equals(this.lastDisconnectedSession);
        }

        private Map<String, Connection> getConnections() {
            return this.connections;
        }
    }
}

