/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.metaserver.provideData.processor;

import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.remoting.metaserver.provideData.ProvideDataProcessor;
import com.alipay.sofa.registry.server.data.renew.DatumLeaseManager;
import org.springframework.beans.factory.annotation.Autowired;

public class DatumExpireProvideDataProcessor
implements ProvideDataProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatumExpireProvideDataProcessor.class);
    @Autowired
    private DatumLeaseManager datumLeaseManager;

    @Override
    public void changeDataProcess(ProvideData provideData) {
        if (this.checkInvalid(provideData)) {
            return;
        }
        boolean enableDataDatumExpire = Boolean.parseBoolean((String)provideData.getProvideData().getObject());
        LOGGER.info("Fetch enableDataDatumExpire {} success!", (Object)enableDataDatumExpire);
        this.datumLeaseManager.setRenewEnable(enableDataDatumExpire);
    }

    private boolean checkInvalid(ProvideData provideData) {
        boolean invalid;
        boolean bl = invalid = provideData == null || provideData.getProvideData() == null || provideData.getProvideData().getObject() == null;
        if (invalid) {
            LOGGER.warn("Fetch enableDataDatumExpire return invalid data, provideData: {}", (Object)provideData);
        }
        return invalid;
    }

    @Override
    public boolean support(ProvideData provideData) {
        return "data.enable.datum.expire.switch#@#9600#@#CONFIG".equals(provideData.getDataInfoId());
    }
}

