/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.metaserver;

import com.alipay.remoting.Connection;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.constants.ValueConstants;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.FetchProvideDataRequest;
import com.alipay.sofa.registry.common.model.metaserver.GetNodesRequest;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.metaserver.RenewNodesRequest;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DataServerCache;
import com.alipay.sofa.registry.server.data.cache.DataServerChangeItem;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.MetaNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import com.alipay.sofa.registry.server.data.remoting.metaserver.IMetaServerService;
import com.alipay.sofa.registry.server.data.remoting.metaserver.MetaServerConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultMetaServiceImpl
implements IMetaServerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMetaServiceImpl.class);
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private MetaNodeExchanger metaNodeExchanger;
    @Autowired
    private MetaServerConnectionFactory metaServerConnectionFactory;
    @Autowired
    private DataServerCache dataServerCache;
    private RaftClient raftClient;
    private AtomicBoolean clientStart = new AtomicBoolean(false);

    @Override
    public Map<String, Set<String>> getMetaServerMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Set<String> set = this.dataServerConfig.getMetaServerIpAddresses();
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerConfig.getLocalDataCenter());
        Connection connection = null;
        try {
            NodeChangeResult result;
            Map metaNodesMap;
            if (connectionMap.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>(set);
                Collections.shuffle(list);
                connection = ((BoltChannel)this.metaNodeExchanger.connect(new URL((String)list.iterator().next(), this.dataServerConfig.getMetaServerPort()))).getConnection();
            } else {
                ArrayList<Connection> connections = new ArrayList<Connection>(connectionMap.values());
                Collections.shuffle(connections);
                connection = (Connection)connections.iterator().next();
                if (!connection.isFine()) {
                    connection = ((BoltChannel)this.metaNodeExchanger.connect(new URL(connection.getRemoteIP(), this.dataServerConfig.getMetaServerPort()))).getConnection();
                }
            }
            final GetNodesRequest request = new GetNodesRequest(Node.NodeType.META);
            final Connection finalConnection = connection;
            Object obj = this.metaNodeExchanger.request(new Request(){

                public Object getRequestBody() {
                    return request;
                }

                public URL getRequestUrl() {
                    return new URL(finalConnection.getRemoteIP(), finalConnection.getRemotePort());
                }
            }).getResult();
            if (obj instanceof NodeChangeResult && (metaNodesMap = (result = (NodeChangeResult)obj).getNodes()) != null && !metaNodesMap.isEmpty()) {
                Map metaNodeMap = (Map)metaNodesMap.get(this.dataServerConfig.getLocalDataCenter());
                if (metaNodeMap != null && !metaNodeMap.isEmpty()) {
                    map.put(this.dataServerConfig.getLocalDataCenter(), metaNodeMap.keySet());
                } else {
                    LOGGER.error("[DefaultMetaServiceImpl] refresh connections from metaServer {} has no result!", (Object)connection.getRemoteIP());
                }
            }
        }
        catch (Exception e) {
            String con = connection != null ? connection.getRemoteIP() : "null";
            LOGGER.error("[DefaultMetaServiceImpl] refresh connections from metaServer error : {}", (Object)con, (Object)e);
            LOGGER.warn("[DefaultMetaServiceImpl] refresh connections from metaServer error,refresh leader : {}", (Object)con);
            throw new RuntimeException("[DefaultMetaServiceImpl] refresh connections from metaServer error!", e);
        }
        return map;
    }

    @Override
    public DataServerNode getDataServer(String dataCenter, String dataInfoId) {
        return DataServerNodeFactory.computeDataServerNode(dataCenter, dataInfoId);
    }

    @Override
    public List<DataServerNode> getDataServers(String dataCenter, String dataInfoId) {
        return DataServerNodeFactory.computeDataServerNodes(dataCenter, dataInfoId, this.dataServerConfig.getStoreNodes());
    }

    @Override
    public Collection<DataServerNode> getDataServers(String dataCenter) {
        return DataServerNodeFactory.getDataServerNodes(dataCenter).values();
    }

    @Override
    public DataServerChangeItem getDateServers() {
        Connection connection;
        String leader;
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerConfig.getLocalDataCenter());
        if (connectionMap.containsKey(leader = this.getLeader().getIp()) && (connection = connectionMap.get(leader)).isFine()) {
            try {
                final GetNodesRequest request = new GetNodesRequest(Node.NodeType.DATA);
                Object obj = this.metaNodeExchanger.request(new Request(){

                    public Object getRequestBody() {
                        return request;
                    }

                    public URL getRequestUrl() {
                        return new URL(connection.getRemoteIP(), connection.getRemotePort());
                    }
                }).getResult();
                if (obj instanceof NodeChangeResult) {
                    NodeChangeResult result = (NodeChangeResult)obj;
                    Map versionMap = result.getDataCenterListVersions();
                    versionMap.put(result.getLocalDataCenter(), result.getVersion());
                    return new DataServerChangeItem(result.getNodes(), versionMap);
                }
            }
            catch (Exception e) {
                LOGGER.error("[ConnectionRefreshTask] refresh connections from metaServer error : {}", (Object)leader, (Object)e);
                String newip = this.refreshLeader().getIp();
                LOGGER.warn("[ConnectionRefreshTask] refresh connections from metaServer error,refresh leader : {}", (Object)newip);
            }
        }
        String newip = this.refreshLeader().getIp();
        LOGGER.warn("[ConnectionRefreshTask] refresh connections metaServer not fine,refresh leader : {}", (Object)newip);
        return null;
    }

    @Override
    public List<String> getOtherDataCenters() {
        HashSet<String> all = new HashSet<String>(this.dataServerCache.getAllDataCenters());
        all.remove(this.dataServerConfig.getLocalDataCenter());
        return new ArrayList<String>(all);
    }

    @Override
    public void renewNodeTask() {
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerConfig.getLocalDataCenter());
        for (Map.Entry<String, Connection> connectEntry : connectionMap.entrySet()) {
            String ip = connectEntry.getKey();
            if (!ip.equals(this.getLeader().getIp())) continue;
            final Connection connection = connectEntry.getValue();
            if (connection.isFine()) {
                try {
                    final RenewNodesRequest renewNodesRequest = new RenewNodesRequest((Node)new DataNode(new URL(DataServerConfig.IP), this.dataServerConfig.getLocalDataCenter()));
                    this.metaNodeExchanger.request(new Request(){

                        public Object getRequestBody() {
                            return renewNodesRequest;
                        }

                        public URL getRequestUrl() {
                            return new URL(connection.getRemoteIP(), connection.getRemotePort());
                        }
                    }).getResult();
                }
                catch (Exception e) {
                    LOGGER.error("[RenewNodeTask] renew data node to metaServer error : {}", (Object)ip, (Object)e);
                    String newip = this.refreshLeader().getIp();
                    LOGGER.warn("[RenewNodeTask] renew data node to metaServer error,leader refresh: {}", (Object)newip);
                }
                continue;
            }
            String newip = this.refreshLeader().getIp();
            LOGGER.warn("[ReNewNodeTask] reNew data node to metaServer not fine,leader refresh: {}", (Object)newip);
        }
    }

    @Override
    public ProvideData fetchData(final String dataInfoId) {
        Connection connection;
        String leader;
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerConfig.getLocalDataCenter());
        if (connectionMap.containsKey(leader = this.getLeader().getIp()) && (connection = connectionMap.get(leader)).isFine()) {
            try {
                Request<FetchProvideDataRequest> request = new Request<FetchProvideDataRequest>(){

                    public FetchProvideDataRequest getRequestBody() {
                        return new FetchProvideDataRequest(dataInfoId);
                    }

                    public URL getRequestUrl() {
                        return new URL(connection.getRemoteIP(), connection.getRemotePort());
                    }
                };
                Response response = this.metaNodeExchanger.request((Request)request);
                Object result = response.getResult();
                if (result instanceof ProvideData) {
                    return (ProvideData)result;
                }
                LOGGER.error("fetch null provider data!");
                throw new RuntimeException("MetaNodeService fetch null provider data!");
            }
            catch (Exception e) {
                LOGGER.error("fetch provider data error! " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("fetch provider data error! " + e.getMessage(), e);
            }
        }
        String newip = this.refreshLeader().getIp();
        LOGGER.warn("[ConnectionRefreshTask] refresh connections metaServer not fine,refresh leader : {}", (Object)newip);
        return null;
    }

    @Override
    public void startRaftClient() {
        try {
            if (this.clientStart.compareAndSet(false, true)) {
                String serverConf = this.getServerConfig();
                this.raftClient = new RaftClient(this.getGroup(), serverConf);
                this.raftClient.start();
            }
        }
        catch (Exception e) {
            LOGGER.error("Start raft client error!", (Throwable)e);
            throw new RuntimeException("Start raft client error!", e);
        }
    }

    private String getServerConfig() {
        String ret = "";
        Set<String> ips = this.dataServerConfig.getMetaServerIpAddresses();
        if (ips != null && !ips.isEmpty()) {
            ret = ips.stream().map(ip -> ip + ":" + ValueConstants.RAFT_SERVER_PORT).collect(Collectors.joining(","));
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("Init raft server config error!");
        }
        return ret;
    }

    private String getGroup() {
        return ValueConstants.RAFT_SERVER_GROUP + "_" + this.dataServerConfig.getLocalDataCenter();
    }

    @Override
    public PeerId getLeader() {
        PeerId leader;
        if (this.raftClient == null) {
            this.startRaftClient();
        }
        if ((leader = this.raftClient.getLeader()) == null) {
            LOGGER.error("[DefaultMetaServiceImpl] register MetaServer get no leader!");
            throw new RuntimeException("[DefaultMetaServiceImpl] register MetaServer get no leader!");
        }
        return leader;
    }

    @Override
    public PeerId refreshLeader() {
        PeerId leader;
        if (this.raftClient == null) {
            this.startRaftClient();
        }
        if ((leader = this.raftClient.refreshLeader()) == null) {
            LOGGER.error("[RaftClientManager] refresh MetaServer get no leader!");
            throw new RuntimeException("[RaftClientManager] refresh MetaServer get no leader!");
        }
        return leader;
    }
}

