/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.handler;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;

public abstract class AbstractServerHandler<T>
implements ChannelHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServerHandler.class);
    private static final Logger LOGGER_CONNECT = LoggerFactory.getLogger((String)"DATA-CONNECT");
    private static final Logger LOGGER_EXCHANGE = LoggerFactory.getLogger((String)"DATA-EXCHANGE");

    public void connected(Channel channel) throws RemotingException {
        if (channel != null && channel.isConnected()) {
            LOGGER_CONNECT.info(this.getConnectNodeType() + " node connected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    public void disconnected(Channel channel) throws RemotingException {
        if (channel != null && !channel.isConnected()) {
            LOGGER_CONNECT.info(this.getConnectNodeType() + " node disconnected,remote address:" + channel.getRemoteAddress() + " localAddress:" + channel.getLocalAddress());
        }
    }

    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }

    public void caught(Channel channel, T message, Throwable exception) {
    }

    public void received(Channel channel, T message) {
    }

    public Object reply(Channel channel, T request) {
        try {
            this.logRequest(channel, request);
            this.checkParam(request);
            return this.doHandle(channel, request);
        }
        catch (Exception e) {
            LOGGER.error("[{}] handle request failed", (Object)this.getClassName(), (Object)e);
            return this.buildFailedResponse(e.getMessage());
        }
    }

    public Class interest() {
        return null;
    }

    public abstract void checkParam(T var1) throws RuntimeException;

    public abstract Object doHandle(Channel var1, T var2);

    public abstract Object buildFailedResponse(String var1);

    protected void logRequest(Channel channel, T request) {
        if (channel != null) {
            this.log("Remote:" + channel.getRemoteAddress() + " Request:" + request);
        } else {
            this.log(request.toString());
        }
    }

    protected void log(String log) {
        LOGGER_EXCHANGE.info("[" + this.getClassName() + "] " + log);
    }

    private String getClassName() {
        return this.getClass().getSimpleName();
    }
}

