/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver.handler;

import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.GetDataRequest;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchDataHandler
extends AbstractClientHandler<GetDataRequest> {
    @Autowired
    private DatumCache datumCache;

    @Override
    public void checkParam(GetDataRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getDataInfoId(), (String)"GetDataRequest.dataInfoId");
    }

    @Override
    public Object doHandle(Channel channel, GetDataRequest request) {
        return new GenericResponse().fillSucceed(this.datumCache.getDatumGroupByDataCenter(request.getDataCenter(), request.getDataInfoId()));
    }

    public GenericResponse<Map<String, Datum>> buildFailedResponse(String msg) {
        return new GenericResponse().fillFailed(msg);
    }

    @Override
    public Class interest() {
        return GetDataRequest.class;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

