/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver;

import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeCallback;
import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.SyncData;
import com.alipay.sofa.registry.common.model.dataserver.SyncDataRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.change.DataChangeTypeEnum;
import com.alipay.sofa.registry.server.data.change.DataSourceTypeEnum;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.remoting.dataserver.GetSyncDataHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.springframework.util.CollectionUtils;

public class SyncDataCallback
implements InvokeCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataCallback.class);
    private static final Executor EXECUTOR = ExecutorFactory.newFixedThreadPool(5, SyncDataCallback.class.getSimpleName());
    private static final int RETRY_COUNT = 3;
    private Connection connection;
    private SyncDataRequest request;
    private GetSyncDataHandler getSyncDataHandler;
    private int retryCount;
    private DataChangeEventCenter dataChangeEventCenter;

    public SyncDataCallback(GetSyncDataHandler getSyncDataHandler, Connection connection, SyncDataRequest request, DataChangeEventCenter dataChangeEventCenter) {
        this.getSyncDataHandler = getSyncDataHandler;
        this.connection = connection;
        this.request = request;
        this.retryCount = 3;
        this.dataChangeEventCenter = dataChangeEventCenter;
    }

    public void onResponse(Object obj) {
        GenericResponse response = (GenericResponse)obj;
        if (!response.isSuccess()) {
            this.getSyncDataHandler.syncData(this);
        } else {
            SyncData syncData = (SyncData)response.getData();
            Collection datums = syncData.getDatums();
            DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.valueOf(this.request.getDataSourceType());
            LOGGER.info("[SyncDataCallback] get syncDatas,datums size={},wholeTag={},dataCenter={},dataInfoId={}", new Object[]{datums.size(), syncData.getWholeDataTag(), syncData.getDataCenter(), syncData.getDataInfoId()});
            if (syncData.getWholeDataTag()) {
                Iterator iterator = datums.iterator();
                if (iterator.hasNext()) {
                    Datum datum = (Datum)iterator.next();
                    if (datum == null) {
                        datum = new Datum();
                        datum.setDataInfoId(syncData.getDataInfoId());
                        datum.setDataCenter(syncData.getDataCenter());
                    }
                    Datum.internDatum((Datum)datum);
                    this.dataChangeEventCenter.sync(DataChangeTypeEnum.COVER, dataSourceTypeEnum, datum);
                }
            } else if (!CollectionUtils.isEmpty((Collection)datums)) {
                for (Datum datum : datums) {
                    if (datum == null) continue;
                    Datum.internDatum((Datum)datum);
                    this.dataChangeEventCenter.sync(DataChangeTypeEnum.MERGE, dataSourceTypeEnum, datum);
                }
            } else {
                LOGGER.info("[SyncDataCallback] get no syncDatas");
            }
        }
    }

    public void onException(Throwable e) {
        GenericResponse genericResponse = new GenericResponse();
        genericResponse.fillFailed(e.getMessage());
        this.onResponse(genericResponse);
    }

    public Executor getExecutor() {
        return EXECUTOR;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SyncDataRequest getRequest() {
        return this.request;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

