/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.consistency.hash.ConsistentHash;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataServerNodeFactory {
    private static final Map<String, Map<String, DataServerNode>> MAP = new ConcurrentHashMap<String, Map<String, DataServerNode>>();
    private static final Map<String, ConsistentHash<DataServerNode>> CONSISTENT_HASH_MAP = new ConcurrentHashMap<String, ConsistentHash<DataServerNode>>();
    private static AtomicBoolean init = new AtomicBoolean(false);

    public static void register(DataServerNode dataServerNode, DataServerConfig dataServerConfig) {
        ConcurrentHashMap<String, DataServerNode> newMap;
        String dataCenter = dataServerNode.getDataCenter();
        ConcurrentHashMap<String, DataServerNode> dataMap = MAP.get(dataCenter);
        if (dataMap == null && (dataMap = (ConcurrentHashMap<String, DataServerNode>)MAP.putIfAbsent(dataCenter, newMap = new ConcurrentHashMap<String, DataServerNode>())) == null) {
            dataMap = newMap;
        }
        dataMap.put(dataServerNode.getIp(), dataServerNode);
        DataServerNodeFactory.refreshConsistent(dataCenter, dataServerConfig);
    }

    public static void refreshConsistent(String dataCenter, DataServerConfig dataServerConfig) {
        ArrayList dataServerNodes = Lists.newArrayList(MAP.get(dataCenter).values());
        if (dataServerConfig.getLocalDataCenter().equals(dataCenter) && !MAP.get(dataCenter).keySet().contains(DataServerConfig.IP)) {
            dataServerNodes.add(new DataServerNode(DataServerConfig.IP, dataServerConfig.getLocalDataCenter(), null));
        }
        CONSISTENT_HASH_MAP.put(dataCenter, (ConsistentHash<DataServerNode>)new ConsistentHash(dataServerConfig.getNumberOfReplicas(), (Collection)dataServerNodes));
    }

    public static void initConsistent(DataServerConfig dataServerConfig) {
        if (init.compareAndSet(false, true)) {
            ArrayList dataServerNodes = Lists.newArrayList();
            dataServerNodes.add(new DataServerNode(DataServerConfig.IP, dataServerConfig.getLocalDataCenter(), null));
            CONSISTENT_HASH_MAP.put(dataServerConfig.getLocalDataCenter(), (ConsistentHash<DataServerNode>)new ConsistentHash(dataServerConfig.getNumberOfReplicas(), (Collection)dataServerNodes));
        }
    }

    public static DataServerNode getDataServerNode(String dataCenter, String ip) {
        Map<String, DataServerNode> map;
        if (MAP.containsKey(dataCenter) && (map = MAP.get(dataCenter)).containsKey(ip)) {
            return map.get(ip);
        }
        return null;
    }

    public static Map<String, DataServerNode> getDataServerNodes(String dataCenter) {
        if (MAP.containsKey(dataCenter)) {
            return MAP.get(dataCenter);
        }
        return new HashMap<String, DataServerNode>();
    }

    public static Set<String> getIps(String dataCenter) {
        Map<String, DataServerNode> map;
        if (MAP.containsKey(dataCenter) && (map = MAP.get(dataCenter)) != null) {
            return map.keySet();
        }
        return new HashSet<String>();
    }

    public static void remove(String dataCenter, String ip, DataServerConfig dataServerConfig) {
        Map<String, DataServerNode> map;
        if (MAP.containsKey(dataCenter) && (map = MAP.get(dataCenter)) != null) {
            DataServerNode dataServerNode = map.get(ip);
            Connection connection = dataServerNode.getConnection();
            if (connection != null && connection.isFine()) {
                connection.close();
            }
            map.remove(ip);
        }
        DataServerNodeFactory.refreshConsistent(dataCenter, dataServerConfig);
    }

    public static void remove(String dataCenter) {
        DataServerNodeFactory.getDataServerNodes(dataCenter).values().stream().map(DataServerNode::getConnection).filter(connection -> connection != null && connection.isFine()).forEach(Connection::close);
        MAP.remove(dataCenter);
        CONSISTENT_HASH_MAP.remove(dataCenter);
    }

    public static DataServerNode computeDataServerNode(String dataCenter, String dataInfoId) {
        ConsistentHash<DataServerNode> consistentHash = CONSISTENT_HASH_MAP.get(dataCenter);
        if (consistentHash != null) {
            return (DataServerNode)consistentHash.getNodeFor((Object)dataInfoId);
        }
        return null;
    }

    public static List<DataServerNode> computeDataServerNodes(String dataCenter, String dataInfoId, int backupNodes) {
        ConsistentHash<DataServerNode> consistentHash = CONSISTENT_HASH_MAP.get(dataCenter);
        if (consistentHash != null) {
            return consistentHash.getNUniqueNodesFor((Object)dataInfoId, backupNodes);
        }
        return null;
    }
}

