/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver;

import com.alipay.remoting.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataServerConnectionFactory {
    private final Map<String, Connection> MAP = new ConcurrentHashMap<String, Connection>();

    public void register(Connection connection) {
        this.MAP.put(this.getConnectId(connection), connection);
    }

    public void remove(Connection connection) {
        this.MAP.remove(this.getConnectId(connection));
    }

    public Connection getConnection(String ip) {
        return this.MAP.values().stream().filter(connection -> ip.equals(connection.getRemoteIP()) && connection.isFine()).findFirst().orElse(null);
    }

    private String getConnectId(Connection connection) {
        return connection.getRemoteIP() + ":" + connection.getRemotePort();
    }
}

