/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.event.StartTaskEvent;
import com.alipay.sofa.registry.server.data.event.handler.AbstractEventHandler;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.remoting.dataserver.task.AbstractTask;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Resource;

public class StartTaskEventHandler
extends AbstractEventHandler<StartTaskEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTaskEventHandler.class);
    private static final Logger LOGGER_START = LoggerFactory.getLogger((String)"DATA-START-LOGS");
    @Resource(name="tasks")
    private List<AbstractTask> tasks;
    private ScheduledExecutorService executor = null;

    @Override
    public List<Class<? extends StartTaskEvent>> interest() {
        return Lists.newArrayList((Object[])new Class[]{StartTaskEvent.class});
    }

    @Override
    public void doHandle(StartTaskEvent event) {
        if (this.executor == null || this.executor.isShutdown()) {
            this.getExecutor();
        }
        for (AbstractTask task : this.tasks) {
            if (!event.getSuitableTypes().contains((Object)task.getStartTaskTypeEnum())) continue;
            this.executor.scheduleWithFixedDelay(task, task.getInitialDelay(), task.getDelay(), task.getTimeUnit());
            LOGGER_START.info("[StartTaskEventHandler] start task:{} success", (Object)task.getName());
        }
    }

    private void getExecutor() {
        this.executor = ExecutorFactory.newScheduledThreadPool(this.tasks.size(), this.getClass().getSimpleName());
    }
}

