/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.remoting.Connection;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.event.DataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import com.alipay.sofa.registry.server.data.event.MetaServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.StartTaskEvent;
import com.alipay.sofa.registry.server.data.event.StartTaskTypeEnum;
import com.alipay.sofa.registry.server.data.event.handler.AbstractEventHandler;
import com.alipay.sofa.registry.server.data.remoting.MetaNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.metaserver.IMetaServerService;
import com.alipay.sofa.registry.server.data.remoting.metaserver.MetaServerConnectionFactory;
import com.alipay.sofa.registry.server.data.util.TimeUtil;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class MetaServerChangeEventHandler
extends AbstractEventHandler<MetaServerChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaServerChangeEventHandler.class);
    private static final int TRY_COUNT = 3;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private IMetaServerService metaServerService;
    @Autowired
    private MetaNodeExchanger metaNodeExchanger;
    @Autowired
    private EventCenter eventCenter;
    @Autowired
    private MetaServerConnectionFactory metaServerConnectionFactory;

    @Override
    public List<Class<? extends MetaServerChangeEvent>> interest() {
        return Lists.newArrayList((Object[])new Class[]{MetaServerChangeEvent.class});
    }

    @Override
    public void doHandle(MetaServerChangeEvent event) {
        Map<String, Set<String>> ipMap = event.getIpMap();
        for (Map.Entry<String, Set<String>> ipEntry : ipMap.entrySet()) {
            String dataCenter = ipEntry.getKey();
            Set<String> ips = ipEntry.getValue();
            if (!CollectionUtils.isEmpty(ips)) {
                for (String ip : ips) {
                    Connection connection = this.metaServerConnectionFactory.getConnection(dataCenter, ip);
                    if (connection != null && connection.isFine()) continue;
                    this.registerMetaServer(dataCenter, ip);
                }
                Set<String> ipSet = this.metaServerConnectionFactory.getIps(dataCenter);
                for (String ip : ipSet) {
                    if (ips.contains(ip)) continue;
                    this.metaServerConnectionFactory.remove(dataCenter, ip);
                    LOGGER.info("[MetaServerChangeEventHandler] remove connection, datacenter:{}, ip:{}", (Object)dataCenter, (Object)ip);
                }
                continue;
            }
            this.removeDataCenter(dataCenter);
        }
        Set<String> dataCenters = this.metaServerConnectionFactory.getAllDataCenters();
        for (String dataCenter : dataCenters) {
            if (ipMap.containsKey(dataCenter)) continue;
            this.removeDataCenter(dataCenter);
        }
    }

    private void registerMetaServer(String dataCenter, final String ip) {
        PeerId leader = this.metaServerService.getLeader();
        for (int tryCount = 0; tryCount < 3; ++tryCount) {
            try {
                Channel channel = this.metaNodeExchanger.connect(new URL(ip, this.dataServerConfig.getMetaServerPort()));
                if (channel != null && channel.isConnected()) {
                    this.metaServerConnectionFactory.register(dataCenter, ip, ((BoltChannel)channel).getConnection());
                }
                if (!ip.equals(leader.getIp())) continue;
                Object obj = null;
                try {
                    obj = this.metaNodeExchanger.request(new Request(){

                        public Object getRequestBody() {
                            return new DataNode(new URL(DataServerConfig.IP), MetaServerChangeEventHandler.this.dataServerConfig.getLocalDataCenter());
                        }

                        public URL getRequestUrl() {
                            return new URL(ip, MetaServerChangeEventHandler.this.dataServerConfig.getMetaServerPort());
                        }
                    }).getResult();
                }
                catch (Exception e) {
                    PeerId newLeader = this.metaServerService.refreshLeader();
                    LOGGER.error(String.format("[MetaServerChangeEventHandler] register data node send error!retry once leader :%s error", newLeader.getIp()), (Throwable)e);
                }
                if (!(obj instanceof NodeChangeResult)) continue;
                NodeChangeResult result = (NodeChangeResult)obj;
                Map versionMap = result.getDataCenterListVersions();
                HashSet<StartTaskTypeEnum> set = new HashSet<StartTaskTypeEnum>();
                set.add(StartTaskTypeEnum.RENEW);
                this.eventCenter.post(new StartTaskEvent(set));
                this.eventCenter.post(new DataServerChangeEvent(result.getNodes(), versionMap, DataServerChangeEvent.FromType.REGISTER_META));
                break;
            }
            catch (Exception e) {
                LOGGER.error("[MetaServerChangeEventHandler] connect metaServer:{} error", (Object)ip, (Object)e);
                TimeUtil.randomDelay(1000);
            }
        }
    }

    private void removeDataCenter(String dataCenter) {
        this.metaServerConnectionFactory.remove(dataCenter);
        LOGGER.info("[MetaServerChangeEventHandler] remove connections of datacenter : {}", (Object)dataCenter);
    }
}

