/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DataServerCache;
import com.alipay.sofa.registry.server.data.cache.DataServerChangeItem;
import com.alipay.sofa.registry.server.data.event.DataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import com.alipay.sofa.registry.server.data.event.LocalDataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.RemoteDataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.handler.AbstractEventHandler;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.DataNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import com.alipay.sofa.registry.server.data.util.TimeUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DataServerChangeEventHandler
extends AbstractEventHandler<DataServerChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServerChangeEventHandler.class);
    private static final int TRY_COUNT = 5;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private DataServerCache dataServerCache;
    @Autowired
    private DataNodeExchanger dataNodeExchanger;
    @Autowired
    private EventCenter eventCenter;

    @Override
    public List<Class<? extends DataServerChangeEvent>> interest() {
        return Lists.newArrayList((Object[])new Class[]{DataServerChangeEvent.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHandle(DataServerChangeEvent event) {
        DataServerChangeEventHandler dataServerChangeEventHandler = this;
        synchronized (dataServerChangeEventHandler) {
            DataServerNodeFactory.initConsistent(this.dataServerConfig);
            DataServerChangeItem dataServerChangeItem = event.getDataServerChangeItem();
            Set<String> localDataServers = this.dataServerCache.getDataServers(this.dataServerConfig.getLocalDataCenter()).keySet();
            Map<String, Set<String>> changedMap = this.dataServerCache.compareAndSet(dataServerChangeItem, event.getFromType());
            if (!changedMap.isEmpty()) {
                for (Map.Entry<String, Set<String>> changeEntry : changedMap.entrySet()) {
                    String dataCenter = changeEntry.getKey();
                    Set<String> ips = changeEntry.getValue();
                    Long newVersion = this.dataServerCache.getDataCenterNewVersion(dataCenter);
                    if (!CollectionUtils.isEmpty(ips)) {
                        for (String string : ips) {
                            DataServerNode dataServerNode;
                            if (StringUtils.equals((String)string, (String)DataServerConfig.IP) || (dataServerNode = DataServerNodeFactory.getDataServerNode(dataCenter, string)) != null && dataServerNode.getConnection() != null && dataServerNode.getConnection().isFine()) continue;
                            this.connectDataServer(dataCenter, string);
                        }
                        Set<String> ipSet = DataServerNodeFactory.getIps(dataCenter);
                        for (String ip3 : ipSet) {
                            if (ips.contains(ip3)) continue;
                            DataServerNodeFactory.remove(dataCenter, ip3, this.dataServerConfig);
                            LOGGER.info("[DataServerChangeEventHandler] remove connection, datacenter:{}, ip:{},from:{}", new Object[]{dataCenter, ip3, event.getFromType()});
                        }
                        Map<String, DataNode> map = this.dataServerCache.getNewDataServerMap(dataCenter);
                        ConcurrentHashMap<String, DataNode> map2 = new ConcurrentHashMap<String, DataNode>(map);
                        if (this.dataServerConfig.isLocalDataCenter(dataCenter)) {
                            HashSet<String> newjoined = new HashSet<String>(ips);
                            newjoined.removeAll(localDataServers);
                            LOGGER.info("Node list change fire LocalDataServerChangeEvent,current node list={},version={},from:{}", new Object[]{map2.keySet(), newVersion, event.getFromType()});
                            this.eventCenter.post(new LocalDataServerChangeEvent(map2, newjoined, dataServerChangeItem.getVersionMap().get(dataCenter), newVersion));
                            continue;
                        }
                        this.dataServerCache.updateItem(map, newVersion, dataCenter);
                        this.eventCenter.post(new RemoteDataServerChangeEvent(dataCenter, map2, dataServerChangeItem.getVersionMap().get(dataCenter), newVersion));
                        continue;
                    }
                    if (!this.dataServerConfig.isLocalDataCenter(dataCenter)) {
                        this.removeDataCenter(dataCenter);
                        this.eventCenter.post(new RemoteDataServerChangeEvent(dataCenter, Collections.EMPTY_MAP, dataServerChangeItem.getVersionMap().get(dataCenter), newVersion));
                    }
                    Map<String, DataNode> newDataNodes = this.dataServerCache.getNewDataServerMap(dataCenter);
                    this.dataServerCache.updateItem(newDataNodes, newVersion, dataCenter);
                }
            } else {
                HashSet<String> allDataCenter = new HashSet<String>(this.dataServerCache.getAllDataCenters());
                for (String dataCenter : allDataCenter) {
                    Map<String, DataNode> dataNodes = this.dataServerCache.getNewDataServerMap(dataCenter);
                    if (dataNodes == null) continue;
                    for (DataNode dataNode : dataNodes.values()) {
                        Connection connection;
                        if (StringUtils.equals((String)dataNode.getIp(), (String)DataServerConfig.IP)) continue;
                        DataServerNode dataServerNode = DataServerNodeFactory.getDataServerNode(dataCenter, dataNode.getIp());
                        Connection connection2 = connection = dataServerNode != null ? dataServerNode.getConnection() : null;
                        if (connection != null && connection.isFine()) continue;
                        LOGGER.warn("[DataServerChangeEventHandler] dataServer connections is not fine, try to reconnect it, old connection={}, dataNode={}, dataCenter={}, from:{}", new Object[]{connection, dataNode.getIp(), dataCenter, event.getFromType()});
                        this.connectDataServer(dataCenter, dataNode.getIp());
                    }
                }
            }
        }
    }

    private void connectDataServer(String dataCenter, String ip) {
        Connection conn = null;
        for (int tryCount = 0; tryCount < 5; ++tryCount) {
            try {
                conn = ((BoltChannel)this.dataNodeExchanger.connect(new URL(ip, this.dataServerConfig.getSyncDataPort()))).getConnection();
                break;
            }
            catch (Exception e) {
                LOGGER.error("[DataServerChangeEventHandler] connect dataServer {} in {} error", new Object[]{ip, dataCenter, e});
                TimeUtil.randomDelay(3000);
                continue;
            }
        }
        if (conn == null || !conn.isFine()) {
            LOGGER.error("[DataServerChangeEventHandler] connect dataServer {} in {} failed five times", (Object)ip, (Object)dataCenter);
            throw new RuntimeException(String.format("[DataServerChangeEventHandler] connect dataServer %s in %s failed five times,dataServer will not work,please check connect!", ip, dataCenter));
        }
        DataServerNodeFactory.register(new DataServerNode(ip, dataCenter, conn), this.dataServerConfig);
    }

    private void removeDataCenter(String dataCenter) {
        DataServerNodeFactory.getDataServerNodes(dataCenter).values().stream().map(DataServerNode::getConnection).filter(connection -> connection != null && connection.isFine()).forEach(Connection::close);
        DataServerNodeFactory.remove(dataCenter);
        LOGGER.info("[DataServerChangeEventHandler] remove connections of dataCenter : {}", (Object)dataCenter);
    }
}

