/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.event.handler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractEventHandler<Event>
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventHandler.class);
    @Autowired
    private EventCenter eventCenter;

    public void afterPropertiesSet() throws Exception {
        this.eventCenter.register(this);
    }

    public void handle(Event event) {
        try {
            this.doHandle(event);
        }
        catch (Exception e) {
            LOGGER.error("[{}] handle event error", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    public abstract List<Class<? extends Event>> interest();

    public abstract void doHandle(Event var1);
}

