/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.change.notify;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.server.data.change.DataSourceTypeEnum;
import com.alipay.sofa.registry.server.data.change.notify.IDataChangeNotifier;
import com.alipay.sofa.registry.server.data.datasync.SnapshotOperator;
import com.alipay.sofa.registry.server.data.datasync.SyncDataService;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class SnapshotBackUpNotifier
implements IDataChangeNotifier {
    @Autowired
    private SyncDataService syncDataService;

    @Override
    public Set<DataSourceTypeEnum> getSuitableSource() {
        HashSet<DataSourceTypeEnum> set = new HashSet<DataSourceTypeEnum>();
        set.add(DataSourceTypeEnum.SNAPSHOT);
        return set;
    }

    @Override
    public void notify(Datum datum, Long lastVersion) {
        this.syncDataService.appendOperator(new SnapshotOperator(datum.getVersion(), lastVersion, datum, DataSourceTypeEnum.BACKUP));
    }
}

