/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.change.event;

import com.alipay.sofa.registry.common.model.PublishType;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.cache.UnPublisher;
import com.alipay.sofa.registry.server.data.change.DataChangeTypeEnum;
import com.alipay.sofa.registry.server.data.change.DataSourceTypeEnum;
import com.alipay.sofa.registry.server.data.change.event.ClientChangeEvent;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEvent;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventQueue;
import com.alipay.sofa.registry.server.data.change.event.DatumSnapshotEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class DataChangeEventCenter {
    private AtomicBoolean isInited = new AtomicBoolean(false);
    private int queueCount;
    private DataChangeEventQueue[] dataChangeEventQueues;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private DatumCache datumCache;

    @PostConstruct
    public void init() {
        if (this.isInited.compareAndSet(false, true)) {
            this.queueCount = this.dataServerConfig.getQueueCount();
            this.dataChangeEventQueues = new DataChangeEventQueue[this.queueCount];
            for (int idx = 0; idx < this.queueCount; ++idx) {
                this.dataChangeEventQueues[idx] = new DataChangeEventQueue(idx, this.dataServerConfig, this, this.datumCache);
                this.dataChangeEventQueues[idx].start();
            }
        }
    }

    public void onChange(Publisher publisher, String dataCenter) {
        int idx = this.hash(publisher.getDataInfoId());
        Datum datum = new Datum(publisher, dataCenter);
        if (publisher instanceof UnPublisher) {
            datum.setContainsUnPub(true);
        }
        if (publisher.getPublishType() != PublishType.TEMPORARY) {
            this.dataChangeEventQueues[idx].onChange(new DataChangeEvent(DataChangeTypeEnum.MERGE, DataSourceTypeEnum.PUB, datum));
        } else {
            this.dataChangeEventQueues[idx].onChange(new DataChangeEvent(DataChangeTypeEnum.MERGE, DataSourceTypeEnum.PUB_TEMP, datum));
        }
    }

    public void clean(Datum datum, DataSourceTypeEnum dataSourceTypeEnum) {
        int idx = this.hash(datum.getDataInfoId());
        this.dataChangeEventQueues[idx].onChange(new DataChangeEvent(DataChangeTypeEnum.COVER, dataSourceTypeEnum, datum));
    }

    public void onChange(ClientChangeEvent event) {
        for (DataChangeEventQueue dataChangeEventQueue : this.dataChangeEventQueues) {
            dataChangeEventQueue.onChange(event);
        }
    }

    public void onChange(DatumSnapshotEvent event) {
        for (DataChangeEventQueue dataChangeEventQueue : this.dataChangeEventQueues) {
            dataChangeEventQueue.onChange(event);
        }
    }

    public void sync(DataChangeTypeEnum changeType, DataSourceTypeEnum sourceType, Datum datum) {
        int idx = this.hash(datum.getDataInfoId());
        DataChangeEvent event = new DataChangeEvent(changeType, sourceType, datum);
        this.dataChangeEventQueues[idx].onChange(event);
    }

    public int hash(String key) {
        if (this.queueCount > 1) {
            return Math.abs(key.hashCode() % this.queueCount);
        }
        return 0;
    }

    public DataChangeEventQueue[] getQueues() {
        return this.dataChangeEventQueues;
    }
}

