/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.cache;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DatumStorage;
import com.alipay.sofa.registry.server.data.cache.MergeResult;
import com.alipay.sofa.registry.server.data.cache.UnPublisher;
import com.alipay.sofa.registry.server.data.change.DataChangeTypeEnum;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalDatumStorage
implements DatumStorage {
    public static final long ERROR_DATUM_VERSION = -2L;
    protected final Map<String, Map<String, Datum>> DATUM_MAP = new ConcurrentHashMap<String, Map<String, Datum>>();
    protected final Map<String, Map<String, Publisher>> ALL_CONNECT_ID_INDEX = new ConcurrentHashMap<String, Map<String, Publisher>>();
    @Autowired
    private DataServerConfig dataServerConfig;

    @Override
    public Datum get(String dataCenter, String dataInfoId) {
        Map<String, Datum> map = this.DATUM_MAP.get(dataCenter);
        if (map != null) {
            return map.get(dataInfoId);
        }
        return null;
    }

    @Override
    public Map<String, Datum> get(String dataInfoId) {
        HashMap<String, Datum> datumMap = new HashMap<String, Datum>();
        this.DATUM_MAP.forEach((dataCenter, datums) -> {
            Datum datum = (Datum)datums.get(dataInfoId);
            if (datum != null) {
                datumMap.put((String)dataCenter, datum);
            }
        });
        return datumMap;
    }

    @Override
    public Map<String, Map<String, Datum>> getAll() {
        return this.DATUM_MAP;
    }

    @Override
    public Map<String, Publisher> getByConnectId(String connectId) {
        return this.ALL_CONNECT_ID_INDEX.getOrDefault(connectId, null);
    }

    @Override
    public Map<String, Publisher> getOwnByConnectId(String connectId) {
        HashMap<String, Publisher> ownPubMap = new HashMap<String, Publisher>();
        Map allPubMap = this.ALL_CONNECT_ID_INDEX.getOrDefault(connectId, null);
        if (allPubMap != null) {
            for (Map.Entry entry : allPubMap.entrySet()) {
                String registerId = (String)entry.getKey();
                Publisher publisher = (Publisher)entry.getValue();
                if (!this.isOwnByMyself(publisher.getDataInfoId())) continue;
                ownPubMap.put(registerId, publisher);
            }
        }
        return ownPubMap;
    }

    protected boolean isOwnByMyself(String dataInfoId) {
        DataServerNode dataServerNode = DataServerNodeFactory.computeDataServerNode(this.dataServerConfig.getLocalDataCenter(), dataInfoId);
        return DataServerConfig.IP.equals(dataServerNode.getIp());
    }

    @Override
    public MergeResult putDatum(DataChangeTypeEnum changeType, Datum datum) {
        MergeResult mergeResult;
        String dataCenter = datum.getDataCenter();
        String dataInfoId = datum.getDataInfoId();
        Map<String, Datum> map = this.getDatumMapByDataCenter(dataCenter);
        if (datum.getDataId() == null && map.get(dataInfoId) == null) {
            MergeResult mergeResult2 = new MergeResult(-2L, false);
            return mergeResult2;
        }
        boolean[] exists = new boolean[]{true};
        Datum cacheDatum = map.computeIfAbsent(dataInfoId, k -> this.filterUnPubs(exists, datum));
        if (!exists[0]) {
            for (Map.Entry entry : datum.getPubMap().entrySet()) {
                Publisher publisher = (Publisher)entry.getValue();
                this.addToIndex(publisher);
            }
            mergeResult = new MergeResult(null, true);
        } else if (changeType == DataChangeTypeEnum.MERGE) {
            mergeResult = this.mergeDatum(cacheDatum, datum);
        } else {
            Long lastVersion = this.coverDatum(datum);
            mergeResult = new MergeResult(lastVersion, true);
        }
        return mergeResult;
    }

    private Datum filterUnPubs(boolean[] exists, Datum datum) {
        Iterator iterator = datum.getPubMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Publisher publisher = (Publisher)entry.getValue();
            if (!(publisher instanceof UnPublisher)) continue;
            iterator.remove();
        }
        exists[0] = false;
        return datum;
    }

    private Map<String, Datum> getDatumMapByDataCenter(String dataCenter) {
        Map<String, Datum> ret;
        Map<String, Datum> map = this.DATUM_MAP.get(dataCenter);
        if (map == null && (ret = this.DATUM_MAP.putIfAbsent(dataCenter, map = new ConcurrentHashMap<String, Datum>())) != null) {
            map = ret;
        }
        return map;
    }

    @Override
    public boolean cleanDatum(String dataCenter, String dataInfoId) {
        Datum cacheDatum;
        Map<String, Datum> datumMap = this.DATUM_MAP.get(dataCenter);
        if (datumMap != null && (cacheDatum = datumMap.remove(dataInfoId)) != null) {
            Map cachePubMap = cacheDatum.getPubMap();
            for (Map.Entry cachePubEntry : cachePubMap.entrySet()) {
                String registerId = (String)cachePubEntry.getKey();
                Publisher cachePub = (Publisher)cachePubEntry.getValue();
                if (cachePub == null) continue;
                cachePubMap.remove(registerId);
                this.removeFromIndex(cachePub);
            }
            return true;
        }
        return false;
    }

    private MergeResult mergeDatum(Datum cacheDatum, Datum datum) {
        boolean isChanged = false;
        Map cachePubMap = cacheDatum.getPubMap();
        Map pubMap = datum.getPubMap();
        for (Map.Entry pubEntry : pubMap.entrySet()) {
            Publisher cachePub;
            String registerId = (String)pubEntry.getKey();
            Publisher pub = (Publisher)pubEntry.getValue();
            if (!this.mergePublisher(pub, cachePubMap, cachePub = (Publisher)cachePubMap.get(registerId))) continue;
            isChanged = true;
        }
        Long lastVersion = cacheDatum.getVersion();
        if (isChanged) {
            cacheDatum.setVersion(datum.getVersion());
        }
        return new MergeResult(lastVersion, isChanged);
    }

    @Override
    public Datum putSnapshot(String dataInfoId, Map<String, Publisher> toBeDeletedPubMap, Map<String, Publisher> snapshotPubMap) {
        String registerId;
        Map<String, Datum> datumMap = this.getDatumMapByDataCenter(this.dataServerConfig.getLocalDataCenter());
        Datum cacheDatum = datumMap.get(dataInfoId);
        if (cacheDatum == null) {
            cacheDatum = new Datum(dataInfoId, this.dataServerConfig.getLocalDataCenter());
            Publisher publisher = snapshotPubMap.values().iterator().next();
            cacheDatum.setInstanceId(publisher.getInstanceId());
            cacheDatum.setDataId(publisher.getDataId());
            cacheDatum.setGroup(publisher.getGroup());
            Datum datum = datumMap.putIfAbsent(dataInfoId, cacheDatum);
            if (datum != null) {
                cacheDatum = datum;
            }
        }
        for (Map.Entry<String, Publisher> toBeDeletedPubEntry : toBeDeletedPubMap.entrySet()) {
            registerId = toBeDeletedPubEntry.getKey();
            Publisher toBeDeletedPub = toBeDeletedPubEntry.getValue();
            if (cacheDatum == null) continue;
            cacheDatum.getPubMap().remove(registerId);
            this.removeFromIndex(toBeDeletedPub);
        }
        for (Map.Entry<String, Publisher> pubEntry : snapshotPubMap.entrySet()) {
            registerId = pubEntry.getKey();
            Publisher snapshotPub = pubEntry.getValue();
            Publisher cachePub = cacheDatum.getPubMap().put(registerId, snapshotPub);
            if (cachePub != null) {
                this.removeFromIndex(cachePub);
            }
            this.addToIndex(snapshotPub);
        }
        cacheDatum.updateVersion();
        return cacheDatum;
    }

    @Override
    public Map<String, Long> getVersions(String dataInfoId) {
        HashMap<String, Long> versions = new HashMap<String, Long>(1);
        Map<String, Datum> datumMap = this.get(dataInfoId);
        if (datumMap != null) {
            for (Map.Entry<String, Datum> entry : datumMap.entrySet()) {
                String dataCenter = entry.getKey();
                Datum datum = entry.getValue();
                versions.put(dataCenter, datum.getVersion());
            }
        }
        return versions;
    }

    private boolean mergePublisher(Publisher pub, Map<String, Publisher> cachePubMap, Publisher cachePub) {
        boolean isChanged = false;
        String registerId = pub.getRegisterId();
        if (pub instanceof UnPublisher) {
            if (cachePub != null && pub.getRegisterTimestamp() > cachePub.getRegisterTimestamp()) {
                cachePubMap.remove(registerId);
                this.removeFromIndex(cachePub);
                isChanged = true;
            }
        } else {
            long cacheVersion;
            long version = pub.getVersion();
            long l = cacheVersion = cachePub == null ? 0L : cachePub.getVersion();
            if (cacheVersion <= version) {
                cachePubMap.put(registerId, pub);
                this.removeFromIndex(cachePub);
                this.addToIndex(pub);
                isChanged = true;
            }
        }
        return isChanged;
    }

    private Long coverDatum(Datum datum) {
        String dataCenter = datum.getDataCenter();
        String dataInfoId = datum.getDataInfoId();
        Datum cacheDatum = this.DATUM_MAP.get(dataCenter).get(dataInfoId);
        if (datum.getVersion() != cacheDatum.getVersion()) {
            this.DATUM_MAP.get(dataCenter).put(dataInfoId, datum);
            Map pubMap = datum.getPubMap();
            HashMap cachePubMap = new HashMap(cacheDatum.getPubMap());
            for (Map.Entry pubEntry : pubMap.entrySet()) {
                String registerId = (String)pubEntry.getKey();
                Publisher pub = (Publisher)pubEntry.getValue();
                this.addToIndex(pub);
                Publisher cachePub = (Publisher)cachePubMap.get(registerId);
                if (cachePub == null || !this.getConnectId(pub).equals(this.getConnectId(cachePub))) continue;
                cachePubMap.remove(registerId);
            }
            if (!cachePubMap.isEmpty()) {
                for (Publisher cachePub : cachePubMap.values()) {
                    this.removeFromIndex(cachePub);
                }
            }
        }
        return cacheDatum.getVersion();
    }

    private void removeFromIndex(Publisher publisher) {
        if (publisher == null) {
            return;
        }
        String connectId = this.getConnectId(publisher);
        Map<String, Publisher> publisherMap = this.ALL_CONNECT_ID_INDEX.get(connectId);
        if (publisherMap != null) {
            publisherMap.remove(publisher.getRegisterId());
        }
    }

    private void addToIndex(Publisher publisher) {
        if (publisher == null) {
            return;
        }
        String connectId = this.getConnectId(publisher);
        Map publisherMap = this.ALL_CONNECT_ID_INDEX.computeIfAbsent(connectId, s -> new ConcurrentHashMap());
        publisherMap.put(publisher.getRegisterId(), publisher);
    }

    private String getConnectId(Publisher cachePub) {
        return WordCache.getInstance().getWordCache(cachePub.getSourceAddress().getAddressString());
    }

    @Override
    public Set<String> getAllConnectIds() {
        return this.ALL_CONNECT_ID_INDEX.keySet();
    }
}

