/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.cache;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.server.data.cache.DatumStorage;
import com.alipay.sofa.registry.server.data.cache.MergeResult;
import com.alipay.sofa.registry.server.data.change.DataChangeTypeEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatumCache {
    @Autowired
    private DatumStorage localDatumStorage;

    public Datum get(String dataCenter, String dataInfoId) {
        return this.localDatumStorage.get(dataCenter, dataInfoId);
    }

    public Map<String, Datum> get(String dataInfoId) {
        HashMap<String, Datum> datumMap = new HashMap<String, Datum>();
        Map<String, Datum> localDataCenterToMap = this.localDatumStorage.get(dataInfoId);
        datumMap.putAll(localDataCenterToMap);
        return datumMap;
    }

    public Map<String, Long> getVersions(String dataInfoId) {
        HashMap<String, Long> datumMap = new HashMap<String, Long>();
        Map<String, Long> localVersions = this.localDatumStorage.getVersions(dataInfoId);
        datumMap.putAll(localVersions);
        return datumMap;
    }

    public Map<String, Datum> getDatumGroupByDataCenter(String dataCenter, String dataInfoId) {
        HashMap<String, Datum> map = new HashMap();
        if (StringUtils.isEmpty((String)dataCenter)) {
            map = this.get(dataInfoId);
        } else {
            Datum datum = this.get(dataCenter, dataInfoId);
            if (datum != null) {
                map.put(dataCenter, datum);
            }
        }
        return map;
    }

    public Map<String, Map<String, Datum>> getAll() {
        return this.localDatumStorage.getAll();
    }

    public Map<String, Publisher> getByConnectId(String connectId) {
        return this.localDatumStorage.getByConnectId(connectId);
    }

    public Map<String, Publisher> getOwnByConnectId(String connectId) {
        return this.localDatumStorage.getOwnByConnectId(connectId);
    }

    public MergeResult putDatum(DataChangeTypeEnum changeType, Datum datum) {
        return this.localDatumStorage.putDatum(changeType, datum);
    }

    public boolean cleanDatum(String dataCenter, String dataInfoId) {
        return this.localDatumStorage.cleanDatum(dataCenter, dataInfoId);
    }

    public Datum putSnapshot(String dataInfoId, Map<String, Publisher> toBeDeletedPubMap, Map<String, Publisher> snapshotPubMap) {
        return this.localDatumStorage.putSnapshot(dataInfoId, toBeDeletedPubMap, snapshotPubMap);
    }

    public Set<String> getAllConnectIds() {
        return this.localDatumStorage.getAllConnectIds();
    }
}

