/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.cache;

import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.consistency.hash.ConsistentHash;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DataServerChangeItem;
import com.alipay.sofa.registry.server.data.event.DataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.handler.AfterWorkingProcessHandler;
import com.alipay.sofa.registry.server.data.node.DataNodeStatus;
import com.alipay.sofa.registry.server.data.util.LocalServerStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;

public class DataServerCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServerCache.class);
    @Autowired
    private DataNodeStatus dataNodeStatus;
    @Autowired
    private DataServerConfig dataServerConfig;
    @Autowired
    private AfterWorkingProcessHandler afterWorkingProcessHandler;
    private volatile DataServerChangeItem dataServerChangeItem = new DataServerChangeItem();
    private volatile DataServerChangeItem newDataServerChangeItem = new DataServerChangeItem();
    private final AtomicBoolean HAS_NOTIFY_ALL = new AtomicBoolean(false);
    private AtomicLong curVersion = new AtomicLong(-1L);
    private Map<Long, Map<String, LocalServerStatusEnum>> nodeStatusMap = new ConcurrentHashMap<Long, Map<String, LocalServerStatusEnum>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> compareAndSet(DataServerChangeItem newItem, DataServerChangeEvent.FromType fromType) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            Map<String, Long> newVersionMap = newItem.getVersionMap();
            Map<String, Long> currentNewVersionMap = this.newDataServerChangeItem.getVersionMap();
            if (!currentNewVersionMap.isEmpty()) {
                AtomicBoolean isTheSame = new AtomicBoolean(true);
                if (newVersionMap.size() == currentNewVersionMap.size()) {
                    for (Map.Entry<String, Long> entry : newVersionMap.entrySet()) {
                        String dataCenter = entry.getKey();
                        Long version = entry.getValue();
                        Long currentVersion = currentNewVersionMap.get(dataCenter);
                        if (currentVersion != null && version != null) {
                            if (currentVersion.longValue() == version.longValue()) continue;
                            isTheSame.set(false);
                        } else {
                            if (currentVersion == null && version == null) continue;
                            isTheSame.set(false);
                        }
                        break;
                    }
                } else {
                    isTheSame.set(false);
                }
                if (isTheSame.get()) {
                    LOGGER.info("current process map has a same version as change map,this change will be ignored!process version={},get version={},from={}", new Object[]{currentNewVersionMap, newVersionMap, fromType});
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return new HashMap<String, Set<String>>();
                }
            }
            HashMap<String, Set<String>> changedMap = new HashMap<String, Set<String>>();
            HashMap<String, Long> oldVersionMap = new HashMap<String, Long>(this.dataServerChangeItem.getVersionMap());
            Map<String, Map<String, DataNode>> newServerMap = newItem.getServerMap();
            for (Map.Entry<String, Long> dataCenterEntry : newVersionMap.entrySet()) {
                Long oldVersion;
                String dataCenter = dataCenterEntry.getKey();
                if (oldVersionMap.containsKey(dataCenter) && (oldVersion = (Long)oldVersionMap.remove(dataCenter)) >= dataCenterEntry.getValue()) continue;
                changedMap.put(dataCenter, newServerMap.get(dataCenter).keySet());
            }
            if (!oldVersionMap.isEmpty()) {
                for (String dataCenter : oldVersionMap.keySet()) {
                    changedMap.put(dataCenter, new HashSet());
                }
            }
            if (changedMap.containsKey(this.dataServerConfig.getLocalDataCenter())) {
                this.init(newVersionMap.get(this.dataServerConfig.getLocalDataCenter()));
            }
            if (!changedMap.isEmpty()) {
                LOGGER.info("old server map = {},from={}", this.dataServerChangeItem.getServerMap(), (Object)fromType);
                LOGGER.info("new server map = {}", newServerMap);
                LOGGER.info("new server version map = {}", newVersionMap);
                LOGGER.info("status map = {}", this.nodeStatusMap);
                LOGGER.info("changed map = {}", changedMap);
                this.newDataServerChangeItem = newItem;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return changedMap;
        }
    }

    private void init(long version) {
        if (this.curVersion.compareAndSet(-1L, version)) {
            ConcurrentHashMap<String, LocalServerStatusEnum> map = new ConcurrentHashMap<String, LocalServerStatusEnum>();
            map.put(DataServerConfig.IP, LocalServerStatusEnum.INITIAL);
            this.nodeStatusMap.put(version, map);
        } else {
            Map<String, LocalServerStatusEnum> map = this.nodeStatusMap.get(this.curVersion.get());
            if (map != null) {
                map.putIfAbsent(DataServerConfig.IP, LocalServerStatusEnum.INITIAL);
            }
        }
    }

    private void addStatus(long version, String ip, LocalServerStatusEnum localServerStatusEnum) {
        long lastVersion = this.curVersion.getAndSet(version);
        ConcurrentHashMap<String, LocalServerStatusEnum> map = this.nodeStatusMap.remove(lastVersion);
        if (map != null) {
            map.put(ip, localServerStatusEnum);
            this.nodeStatusMap.put(this.curVersion.get(), map);
        } else {
            ConcurrentHashMap<String, LocalServerStatusEnum> newMap = new ConcurrentHashMap<String, LocalServerStatusEnum>();
            map = this.nodeStatusMap.putIfAbsent(this.curVersion.get(), newMap);
            if (map == null) {
                map = newMap;
            }
            map.put(ip, localServerStatusEnum);
        }
    }

    private void resetStatusMapToWorking() {
        Map<String, LocalServerStatusEnum> map = this.nodeStatusMap.get(this.curVersion.get());
        if (map != null) {
            map.clear();
            map.put(DataServerConfig.IP, LocalServerStatusEnum.WORKING);
        }
        LOGGER.info("nodeStatusMap has been reset!Result {}", this.nodeStatusMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNotifyNewStatusNode(String ip) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            LocalServerStatusEnum statusEnum;
            Map<String, LocalServerStatusEnum> map = this.nodeStatusMap.get(this.curVersion.get());
            if (map != null && (statusEnum = map.get(ip)) != null && statusEnum == LocalServerStatusEnum.INITIAL && map.remove(ip) != null) {
                LOGGER.info("nodeStatusMap remove init status node {}!Result {}", (Object)ip, this.nodeStatusMap);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synced(long version, String ip) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            if (version >= this.curVersion.get()) {
                this.addStatus(version, ip, LocalServerStatusEnum.WORKING);
                LOGGER.info("synced working = {}, version={},send ip={}", new Object[]{this.nodeStatusMap, version, ip});
                this.updateDataServerStatus();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotWorkingServer(long version, String ip) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            if (version >= this.curVersion.get()) {
                this.addStatus(version, ip, LocalServerStatusEnum.INITIAL);
                LOGGER.info("add not working = {}, version={},send ip={}", new Object[]{this.nodeStatusMap, version, ip});
                if (this.dataNodeStatus.getStatus() != LocalServerStatusEnum.WORKING) {
                    this.updateDataServerStatus();
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private void updateDataServerStatus() {
        if (this.dataNodeStatus.getStatus() != LocalServerStatusEnum.WORKING) {
            Long newVersion = this.newDataServerChangeItem.getVersionMap().get(this.dataServerConfig.getLocalDataCenter());
            if (newVersion == null) {
                LOGGER.info("no node change receive from meta about current dataCenter!");
                return;
            }
            if (newVersion.longValue() != this.curVersion.get()) {
                LOGGER.info("version not match,current {} push {}", (Object)this.curVersion.longValue(), (Object)newVersion);
                return;
            }
            Map<String, LocalServerStatusEnum> map = this.nodeStatusMap.get(this.curVersion.get());
            if (map != null) {
                Set<String> itemIps;
                Set<String> ips = map.keySet();
                if (!ips.containsAll(itemIps = this.newDataServerChangeItem.getServerMap().get(this.dataServerConfig.getLocalDataCenter()).keySet())) {
                    LOGGER.info("nodeStatusMap not contains all push list,nodeStatusMap {},push {},diff1{},diff2{}", new Object[]{this.nodeStatusMap, itemIps, Sets.difference(ips, itemIps), Sets.difference(itemIps, ips)});
                    return;
                }
            } else {
                LOGGER.info("nodeStatusMap has not got other data node status!");
                return;
            }
            if (!this.HAS_NOTIFY_ALL.get()) {
                LOGGER.info("Has not notify all!");
                return;
            }
            this.dataNodeStatus.setStatus(LocalServerStatusEnum.WORKING);
            this.updateItem(this.newDataServerChangeItem.getServerMap().get(this.dataServerConfig.getLocalDataCenter()), newVersion, this.dataServerConfig.getLocalDataCenter());
            this.resetStatusMapToWorking();
            this.afterWorkingProcessHandler.afterWorkingProcess();
        }
    }

    public Long getCurVersion() {
        return this.curVersion.get();
    }

    public void notifiedAll() {
        if (this.HAS_NOTIFY_ALL.compareAndSet(false, true)) {
            this.updateDataServerStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndUpdateStatus(long version) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            if (version == this.curVersion.get()) {
                this.updateDataServerStatus();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNotWorking() {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            HashSet<String> ret = new HashSet<String>();
            Map<String, LocalServerStatusEnum> map = this.nodeStatusMap.get(this.curVersion.get());
            if (map != null) {
                map.forEach((ip, status) -> {
                    if (status != LocalServerStatusEnum.WORKING) {
                        ret.add((String)ip);
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateItem(Map<String, DataNode> localDataNodes, Long version, String dataCenter) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            Long oldVersion = this.dataServerChangeItem.getVersionMap().get(dataCenter);
            Map<String, DataNode> oldList = this.dataServerChangeItem.getServerMap().get(dataCenter);
            Set<Object> oldIps = oldList == null ? new HashSet() : oldList.keySet();
            Set<Object> newIps = localDataNodes == null ? new HashSet() : localDataNodes.keySet();
            LOGGER.warn("Update DataCenter={} Item version from={} to={},nodeMap from={} to={}", new Object[]{dataCenter, oldVersion, version, oldIps, newIps});
            this.dataServerChangeItem.getServerMap().put(dataCenter, localDataNodes);
            this.dataServerChangeItem.getVersionMap().put(dataCenter, version);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public Map<String, DataNode> getDataServers(String dataCenter) {
        return this.getDataServers(dataCenter, this.dataServerChangeItem);
    }

    public Map<String, DataNode> getDataServers(String dataCenter, DataServerChangeItem dataServerChangeItem) {
        return this.doGetDataServers(dataCenter, dataServerChangeItem);
    }

    public Map<String, DataNode> getNewDataServerMap(String dataCenter) {
        return this.doGetDataServers(dataCenter, this.newDataServerChangeItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DataNode> doGetDataServers(String dataCenter, DataServerChangeItem dataServerChangeItem) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            Map<String, Map<String, DataNode>> dataserverMap = dataServerChangeItem.getServerMap();
            if (dataserverMap.containsKey(dataCenter)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return dataserverMap.get(dataCenter);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new HashMap<String, DataNode>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getDataCenterNewVersion(String dataCenter) {
        Class<DataServerCache> clazz = DataServerCache.class;
        synchronized (DataServerCache.class) {
            Map<String, Long> versionMap = this.newDataServerChangeItem.getVersionMap();
            if (versionMap.containsKey(dataCenter)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return versionMap.get(dataCenter);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public ConsistentHash<DataNode> calculateOldConsistentHash(String dataCenter) {
        ArrayList dataServerNodes;
        Map<String, Map<String, DataNode>> dataServerMap = this.dataServerChangeItem.getServerMap();
        Map<String, DataNode> dataNodeMap = dataServerMap.get(dataCenter);
        if (dataNodeMap != null && !dataNodeMap.isEmpty()) {
            dataServerNodes = dataNodeMap.values();
        } else {
            dataServerNodes = Lists.newArrayList((Object[])new DataNode[]{new DataNode(new URL(DataServerConfig.IP), dataCenter)});
            LOGGER.error("[calculateOldConsistentHash] Old dataServer list is empty, add on the local IP");
        }
        ConsistentHash consistentHash = new ConsistentHash(this.dataServerConfig.getNumberOfReplicas(), dataServerNodes);
        return consistentHash;
    }

    public Set<String> getAllDataCenters() {
        return this.newDataServerChangeItem.getVersionMap().keySet();
    }
}

