/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.cache;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CacheDigestTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheDigestTask.class);
    @Autowired
    private DatumCache datumCache;

    public void start() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("CacheDigestTask"));
        executor.scheduleAtFixedRate(() -> {
            try {
                Map<String, Map<String, Datum>> allMap = this.datumCache.getAll();
                if (!allMap.isEmpty()) {
                    for (Map.Entry<String, Map<String, Datum>> dataCenterEntry : allMap.entrySet()) {
                        String dataCenter = dataCenterEntry.getKey();
                        Map<String, Datum> datumMap = dataCenterEntry.getValue();
                        LOGGER.info("[CacheDigestTask] size of datum in {} is {}", (Object)dataCenter, (Object)datumMap.size());
                        for (Map.Entry<String, Datum> dataInfoEntry : datumMap.entrySet()) {
                            String dataInfoId = dataInfoEntry.getKey();
                            Datum data = dataInfoEntry.getValue();
                            Map pubMap = data.getPubMap();
                            StringBuilder pubStr = new StringBuilder();
                            if (!CollectionUtils.isEmpty((Map)pubMap)) {
                                for (Publisher publisher : pubMap.values()) {
                                    pubStr.append(this.logPublisher(publisher)).append(";");
                                }
                            }
                            LOGGER.info("[Datum]{},{},{},[{}]", new Object[]{dataInfoId, data.getVersion(), dataCenter, pubStr.toString()});
                        }
                        int pubCount = datumMap.values().stream().map(Datum::getPubMap).filter(map -> map != null && !map.isEmpty()).mapToInt(Map::size).sum();
                        LOGGER.info("[CacheDigestTask] size of publisher in {} is {}", (Object)dataCenter, (Object)pubCount);
                    }
                } else {
                    LOGGER.info("[CacheDigestTask] datum cache is empty");
                }
            }
            catch (Throwable t) {
                LOGGER.error("[CacheDigestTask] cache digest error", t);
            }
        }, 30L, 600L, TimeUnit.SECONDS);
    }

    private String logPublisher(Publisher publisher) {
        if (publisher != null) {
            URL url = publisher.getSourceAddress();
            String urlStr = url != null ? url.getAddressString() : "null";
            return String.format("%s,%s,%s,%s", publisher.getRegisterId(), publisher.getRegisterTimestamp(), urlStr, publisher.getVersion());
        }
        return "";
    }
}

