/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.bootstrap;

import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.data.bootstrap.CommonConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="data.server")
public class DataServerConfig {
    public static final String PRE_FIX = "data.server";
    public static final String IP = NetUtil.getLocalAddress().getHostAddress();
    private int port;
    private int syncDataPort;
    private int metaServerPort;
    private int httpServerPort;
    private int queueCount;
    private int queueSize;
    private int notifyIntervalMs;
    private int clientOffDelayMs;
    private int notifyTempDataIntervalMs;
    private int rpcTimeout;
    private CommonConfig commonConfig;
    private Set<String> metaIps = null;
    private int storeNodes = 3;
    private int numberOfReplicas = 1000;
    private long localDataServerCleanDelay = 1800000L;
    private int getDataExecutorMinPoolSize = 80;
    private int getDataExecutorMaxPoolSize = 400;
    private int getDataExecutorQueueSize = 10000;
    private long getDataExecutorKeepAliveTime = 60L;
    private int notifyDataSyncExecutorMinPoolSize = 80;
    private int notifyDataSyncExecutorMaxPoolSize = 400;
    private int notifyDataSyncExecutorQueueSize = 700;
    private long notifyDataSyncExecutorKeepAliveTime = 60L;
    private long notifySessionRetryFirstDelay = 3000L;
    private long notifySessionRetryIncrementDelay = 3000L;
    private int notifySessionRetryTimes = 5;
    private int publishExecutorMinPoolSize = 200;
    private int publishExecutorMaxPoolSize = 400;
    private int publishExecutorQueueSize = 10000;
    private int renewDatumExecutorMinPoolSize = 100;
    private int renewDatumExecutorMaxPoolSize = 400;
    private int renewDatumExecutorQueueSize = 100000;
    private int datumTimeToLiveSec = 900;
    private int datumLeaseManagerExecutorThreadSize = 1;
    private int datumLeaseManagerExecutorQueueSize = 1000000;
    private int sessionServerNotifierRetryExecutorThreadSize = 10;
    private int sessionServerNotifierRetryExecutorQueueSize = 10000;
    private int renewEnableDelaySec = 30;
    private int dataSyncDelayTimeout = 1000;
    private int dataSyncNotifyRetry = 3;

    public DataServerConfig(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public boolean isLocalDataCenter(String dataCenter) {
        return this.commonConfig.getLocalDataCenter().equals(dataCenter);
    }

    public int getRenewEnableDelaySec() {
        return this.renewEnableDelaySec;
    }

    public void setRenewEnableDelaySec(int renewEnableDelaySec) {
        this.renewEnableDelaySec = renewEnableDelaySec;
    }

    public String getLocalDataCenter() {
        return this.commonConfig.getLocalDataCenter();
    }

    public int getRenewDatumExecutorMinPoolSize() {
        return this.renewDatumExecutorMinPoolSize;
    }

    public void setRenewDatumExecutorMinPoolSize(int renewDatumExecutorMinPoolSize) {
        this.renewDatumExecutorMinPoolSize = renewDatumExecutorMinPoolSize;
    }

    public int getRenewDatumExecutorMaxPoolSize() {
        return this.renewDatumExecutorMaxPoolSize;
    }

    public void setRenewDatumExecutorMaxPoolSize(int renewDatumExecutorMaxPoolSize) {
        this.renewDatumExecutorMaxPoolSize = renewDatumExecutorMaxPoolSize;
    }

    public int getRenewDatumExecutorQueueSize() {
        return this.renewDatumExecutorQueueSize;
    }

    public void setRenewDatumExecutorQueueSize(int renewDatumExecutorQueueSize) {
        this.renewDatumExecutorQueueSize = renewDatumExecutorQueueSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSyncDataPort() {
        return this.syncDataPort;
    }

    public void setSyncDataPort(int syncDataPort) {
        this.syncDataPort = syncDataPort;
    }

    public int getMetaServerPort() {
        return this.metaServerPort;
    }

    public void setMetaServerPort(int metaServerPort) {
        this.metaServerPort = metaServerPort;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    public int getQueueCount() {
        return this.queueCount;
    }

    public void setQueueCount(int queueCount) {
        this.queueCount = queueCount;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getNotifyIntervalMs() {
        return this.notifyIntervalMs;
    }

    public void setNotifyIntervalMs(int notifyIntervalMs) {
        this.notifyIntervalMs = notifyIntervalMs;
    }

    public int getNotifyTempDataIntervalMs() {
        return this.notifyTempDataIntervalMs;
    }

    public void setNotifyTempDataIntervalMs(int notifyTempDataIntervalMs) {
        this.notifyTempDataIntervalMs = notifyTempDataIntervalMs;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public int getStoreNodes() {
        return this.storeNodes;
    }

    public void setStoreNodes(int storeNodes) {
        this.storeNodes = storeNodes;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public long getLocalDataServerCleanDelay() {
        return this.localDataServerCleanDelay;
    }

    public void setLocalDataServerCleanDelay(long localDataServerCleanDelay) {
        this.localDataServerCleanDelay = localDataServerCleanDelay;
    }

    public int getGetDataExecutorMinPoolSize() {
        return this.getDataExecutorMinPoolSize;
    }

    public int getGetDataExecutorMaxPoolSize() {
        return this.getDataExecutorMaxPoolSize;
    }

    public int getGetDataExecutorQueueSize() {
        return this.getDataExecutorQueueSize;
    }

    public long getGetDataExecutorKeepAliveTime() {
        return this.getDataExecutorKeepAliveTime;
    }

    public void setGetDataExecutorMinPoolSize(int getDataExecutorMinPoolSize) {
        this.getDataExecutorMinPoolSize = getDataExecutorMinPoolSize;
    }

    public void setGetDataExecutorMaxPoolSize(int getDataExecutorMaxPoolSize) {
        this.getDataExecutorMaxPoolSize = getDataExecutorMaxPoolSize;
    }

    public void setGetDataExecutorQueueSize(int getDataExecutorQueueSize) {
        this.getDataExecutorQueueSize = getDataExecutorQueueSize;
    }

    public void setGetDataExecutorKeepAliveTime(long getDataExecutorKeepAliveTime) {
        this.getDataExecutorKeepAliveTime = getDataExecutorKeepAliveTime;
    }

    public int getNotifyDataSyncExecutorMinPoolSize() {
        return this.notifyDataSyncExecutorMinPoolSize;
    }

    public void setNotifyDataSyncExecutorMinPoolSize(int notifyDataSyncExecutorMinPoolSize) {
        this.notifyDataSyncExecutorMinPoolSize = notifyDataSyncExecutorMinPoolSize;
    }

    public int getNotifyDataSyncExecutorMaxPoolSize() {
        return this.notifyDataSyncExecutorMaxPoolSize;
    }

    public void setNotifyDataSyncExecutorMaxPoolSize(int notifyDataSyncExecutorMaxPoolSize) {
        this.notifyDataSyncExecutorMaxPoolSize = notifyDataSyncExecutorMaxPoolSize;
    }

    public int getNotifyDataSyncExecutorQueueSize() {
        return this.notifyDataSyncExecutorQueueSize;
    }

    public void setNotifyDataSyncExecutorQueueSize(int notifyDataSyncExecutorQueueSize) {
        this.notifyDataSyncExecutorQueueSize = notifyDataSyncExecutorQueueSize;
    }

    public long getNotifyDataSyncExecutorKeepAliveTime() {
        return this.notifyDataSyncExecutorKeepAliveTime;
    }

    public void setNotifyDataSyncExecutorKeepAliveTime(long notifyDataSyncExecutorKeepAliveTime) {
        this.notifyDataSyncExecutorKeepAliveTime = notifyDataSyncExecutorKeepAliveTime;
    }

    public long getNotifySessionRetryFirstDelay() {
        return this.notifySessionRetryFirstDelay;
    }

    public void setNotifySessionRetryFirstDelay(long notifySessionRetryFirstDelay) {
        this.notifySessionRetryFirstDelay = notifySessionRetryFirstDelay;
    }

    public long getNotifySessionRetryIncrementDelay() {
        return this.notifySessionRetryIncrementDelay;
    }

    public void setNotifySessionRetryIncrementDelay(long notifySessionRetryIncrementDelay) {
        this.notifySessionRetryIncrementDelay = notifySessionRetryIncrementDelay;
    }

    public int getClientOffDelayMs() {
        return this.clientOffDelayMs;
    }

    public void setClientOffDelayMs(int clientOffDelayMs) {
        this.clientOffDelayMs = clientOffDelayMs;
    }

    public int getPublishExecutorMinPoolSize() {
        return this.publishExecutorMinPoolSize;
    }

    public void setPublishExecutorMinPoolSize(int publishExecutorMinPoolSize) {
        this.publishExecutorMinPoolSize = publishExecutorMinPoolSize;
    }

    public int getPublishExecutorMaxPoolSize() {
        return this.publishExecutorMaxPoolSize;
    }

    public void setPublishExecutorMaxPoolSize(int publishExecutorMaxPoolSize) {
        this.publishExecutorMaxPoolSize = publishExecutorMaxPoolSize;
    }

    public int getPublishExecutorQueueSize() {
        return this.publishExecutorQueueSize;
    }

    public void setPublishExecutorQueueSize(int publishExecutorQueueSize) {
        this.publishExecutorQueueSize = publishExecutorQueueSize;
    }

    public Set<String> getMetaServerIpAddresses() {
        Collection<String> metas;
        String localDataCenter;
        Map<String, Collection<String>> metaMap;
        if (this.metaIps != null && !this.metaIps.isEmpty()) {
            return this.metaIps;
        }
        this.metaIps = new HashSet<String>();
        if (!(this.commonConfig == null || (metaMap = this.commonConfig.getMetaNode()) == null || metaMap.isEmpty() || (localDataCenter = this.commonConfig.getLocalDataCenter()) == null || localDataCenter.isEmpty() || (metas = metaMap.get(localDataCenter)) == null || metas.isEmpty())) {
            this.metaIps = metas.stream().map(NetUtil::getIPAddressFromDomain).collect(Collectors.toSet());
        }
        return this.metaIps;
    }

    public int getNotifySessionRetryTimes() {
        return this.notifySessionRetryTimes;
    }

    public void setNotifySessionRetryTimes(int notifySessionRetryTimes) {
        this.notifySessionRetryTimes = notifySessionRetryTimes;
    }

    public int getDatumTimeToLiveSec() {
        return this.datumTimeToLiveSec;
    }

    public void setDatumTimeToLiveSec(int datumTimeToLiveSec) {
        this.datumTimeToLiveSec = datumTimeToLiveSec;
    }

    public int getDatumLeaseManagerExecutorQueueSize() {
        return this.datumLeaseManagerExecutorQueueSize;
    }

    public void setDatumLeaseManagerExecutorQueueSize(int datumLeaseManagerExecutorQueueSize) {
        this.datumLeaseManagerExecutorQueueSize = datumLeaseManagerExecutorQueueSize;
    }

    public int getDatumLeaseManagerExecutorThreadSize() {
        return this.datumLeaseManagerExecutorThreadSize;
    }

    public void setDatumLeaseManagerExecutorThreadSize(int datumLeaseManagerExecutorThreadSize) {
        this.datumLeaseManagerExecutorThreadSize = datumLeaseManagerExecutorThreadSize;
    }

    public int getSessionServerNotifierRetryExecutorThreadSize() {
        return this.sessionServerNotifierRetryExecutorThreadSize;
    }

    public void setSessionServerNotifierRetryExecutorThreadSize(int sessionServerNotifierRetryExecutorThreadSize) {
        this.sessionServerNotifierRetryExecutorThreadSize = sessionServerNotifierRetryExecutorThreadSize;
    }

    public int getSessionServerNotifierRetryExecutorQueueSize() {
        return this.sessionServerNotifierRetryExecutorQueueSize;
    }

    public void setSessionServerNotifierRetryExecutorQueueSize(int sessionServerNotifierRetryExecutorQueueSize) {
        this.sessionServerNotifierRetryExecutorQueueSize = sessionServerNotifierRetryExecutorQueueSize;
    }

    public int getDataSyncDelayTimeout() {
        return this.dataSyncDelayTimeout;
    }

    public void setDataSyncDelayTimeout(int dataSyncDelayTimeout) {
        this.dataSyncDelayTimeout = dataSyncDelayTimeout;
    }

    public int getDataSyncNotifyRetry() {
        return this.dataSyncNotifyRetry;
    }

    public void setDataSyncNotifyRetry(int dataSyncNotifyRetry) {
        this.dataSyncNotifyRetry = dataSyncNotifyRetry;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

