/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.UnPublishDataRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.UnPublisher;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.sessionserver.forward.ForwardService;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class UnPublishDataHandler
extends AbstractServerHandler<UnPublishDataRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnPublishDataHandler.class);
    @Autowired
    private ForwardService forwardService;
    @Autowired
    private DataChangeEventCenter dataChangeEventCenter;
    @Autowired
    private DataServerConfig dataServerConfig;

    @Override
    public void checkParam(UnPublishDataRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getDataInfoId(), (String)"UnPublishDataRequest.dataInfoId");
        ParaCheckUtil.checkNotBlank((String)request.getRegisterId(), (String)"UnPublishDataRequest.registerId");
    }

    @Override
    public Object doHandle(Channel channel, UnPublishDataRequest request) {
        if (this.forwardService.needForward(request.getDataInfoId())) {
            LOGGER.warn("[forward] UnPublish request refused, request: {}", (Object)request);
            CommonResponse response = new CommonResponse();
            response.setSuccess(false);
            response.setMessage("Request refused, Server status is not working");
            return response;
        }
        this.dataChangeEventCenter.onChange(new UnPublisher(request.getDataInfoId(), request.getRegisterId(), request.getRegisterTimestamp()), this.dataServerConfig.getLocalDataCenter());
        return CommonResponse.buildSuccessResponse();
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return UnPublishDataRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

