/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.sessionserver.handler;

import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.GetDataVersionRequest;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetDataVersionsHandler
extends AbstractServerHandler<GetDataVersionRequest> {
    @Override
    protected void logRequest(Channel channel, GetDataVersionRequest request) {
    }

    @Override
    public void checkParam(GetDataVersionRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotEmpty((Collection)request.getDataInfoIds(), (String)"GetDataVersionRequest.dataInfoIds");
    }

    @Override
    public Object doHandle(Channel channel, GetDataVersionRequest request) {
        HashMap map = new HashMap();
        List dataInfoIds = request.getDataInfoIds();
        for (String dataInfoId : dataInfoIds) {
            Map<String, Datum> datumMap = DatumCache.get(dataInfoId);
            Set<Map.Entry<String, Datum>> entrySet = datumMap.entrySet();
            for (Map.Entry<String, Datum> entry : entrySet) {
                String dataCenter = entry.getKey();
                Datum datum = entry.getValue();
                if (datum == null) continue;
                if (!map.containsKey(dataCenter)) {
                    map.put(dataCenter, new HashMap());
                }
                ((Map)map.get(dataCenter)).put(dataInfoId, datum.getVersion());
            }
        }
        return new GenericResponse().fillSucceed(map);
    }

    public GenericResponse<Map<String, Map<String, Long>>> buildFailedResponse(String msg) {
        return new GenericResponse().fillFailed(msg);
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return GetDataVersionRequest.class;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

