/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.server.data.remoting.metaserver.IMetaServerService;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

public class MetaNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaNodeExchanger.class);
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private IMetaServerService metaServerService;
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Resource(name="metaClientHandlers")
    private Collection<AbstractClientHandler> metaClientHandlers;

    public Response request(Request request) {
        Channel channel = this.connect(request.getRequestUrl());
        Client client = this.boltExchange.getClient("metaServer");
        LOGGER.info("MetaNode Exchanger request={},url={},callbackHandler={}", new Object[]{request.getRequestBody(), request.getRequestUrl(), request.getCallBackHandler()});
        try {
            Object result = client.sendSync(channel, request.getRequestBody(), this.dataServerBootstrapConfig.getRpcTimeout());
            return () -> result;
        }
        catch (Exception e) {
            URL url = new URL(this.metaServerService.refreshLeader().getIp(), this.dataServerBootstrapConfig.getMetaServerPort());
            channel = client.getChannel(url);
            if (channel == null) {
                channel = client.connect(url);
            }
            LOGGER.warn("MetaNode Exchanger request send error!It will be retry once!Request url:{}", (Object)url);
            Object result = client.sendSync(channel, request.getRequestBody(), this.dataServerBootstrapConfig.getRpcTimeout());
            return () -> result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel connect(URL url) {
        Channel channel;
        Client client = this.boltExchange.getClient("metaServer");
        if (client == null) {
            MetaNodeExchanger metaNodeExchanger = this;
            synchronized (metaNodeExchanger) {
                client = this.boltExchange.getClient("metaServer");
                if (client == null) {
                    client = this.boltExchange.connect("metaServer", url, (Object[])this.metaClientHandlers.toArray(new ChannelHandler[this.metaClientHandlers.size()]));
                }
            }
        }
        if ((channel = client.getChannel(url)) == null) {
            MetaNodeExchanger metaNodeExchanger = this;
            synchronized (metaNodeExchanger) {
                channel = client.getChannel(url);
                if (channel == null) {
                    channel = client.connect(url);
                }
            }
        }
        return channel;
    }

    public Client connectServer() {
        throw new UnsupportedOperationException();
    }
}

