/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.executor;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorFactory {
    public static final ThreadPoolExecutor EXECUTOR;
    private static final Logger LOGGER;

    public static ThreadPoolExecutor getCommonExecutor() {
        return EXECUTOR;
    }

    public static Executor newFixedThreadPool(int size, String name) {
        return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(name));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String name) {
        return new ScheduledThreadPoolExecutor(size, (ThreadFactory)new NamedThreadFactory(name));
    }

    public static Executor newSingleThreadExecutor(String name) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(name));
    }

    static {
        LOGGER = LoggerFactory.getLogger(ExecutorFactory.class);
        ArrayBlockingQueue workQueue = new ArrayBlockingQueue(10);
        EXECUTOR = new ThreadPoolExecutor(20, 300, 1L, TimeUnit.HOURS, (BlockingQueue)workQueue, (ThreadFactory)new NamedThreadFactory("CommonExecutor")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t != null) {
                    LOGGER.error("[CommonThreadPool] ThreadPoolUncaughtException:{}", (Object)t.getMessage(), (Object)t);
                }
            }
        };
    }
}

