/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.correction;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.consistency.hash.ConsistentHash;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.BackupTriad;
import com.alipay.sofa.registry.server.data.cache.DataServerCache;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.change.DataSourceTypeEnum;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.util.DelayItem;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalDataServerCleanHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDataServerCleanHandler.class);
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Autowired
    private DataServerCache dataServerCache;
    @Autowired
    private DataChangeEventCenter dataChangeEventCenter;
    private LocalCleanTask task;
    private final DelayQueue<DelayItem<LocalCleanTask>> EVENT_QUEUE = new DelayQueue();

    public LocalDataServerCleanHandler() {
        LOGGER.info("[LocalDataServerCleanHandler] begin start LocalDataServerCleanHandler");
        Executor executor = ExecutorFactory.newSingleThreadExecutor(LocalDataServerCleanHandler.class.getSimpleName());
        executor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        DelayItem delayItem = (DelayItem)this.EVENT_QUEUE.take();
                        this.task = (LocalCleanTask)delayItem.getItem();
                        this.task.run();
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("[LocalDataServerCleanHandler] handle clean task failed", e);
                    continue;
                }
                break;
            }
        });
        LOGGER.info("[LocalDataServerCleanHandler] start LocalDataServerCleanHandler success");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Class<LocalDataServerCleanHandler> clazz = LocalDataServerCleanHandler.class;
        synchronized (LocalDataServerCleanHandler.class) {
            if (this.EVENT_QUEUE.isEmpty() && this.task != null) {
                this.task.stop();
                this.EVENT_QUEUE.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.EVENT_QUEUE.add(new DelayItem<LocalCleanTask>(new LocalCleanTask(), this.dataServerBootstrapConfig.getLocalDataServerCleanDelay()));
            return;
        }
    }

    private class LocalCleanTask {
        private AtomicBoolean running = new AtomicBoolean(false);

        private LocalCleanTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.running.compareAndSet(false, true)) {
                try {
                    Map<String, DataNode> dataNodeMap = LocalDataServerCleanHandler.this.dataServerCache.getDataServers(LocalDataServerCleanHandler.this.dataServerBootstrapConfig.getLocalDataCenter());
                    if (dataNodeMap == null || dataNodeMap.isEmpty()) {
                        LOGGER.warn("Calculate Old BackupTriad,old dataServer list is empty!");
                        return;
                    }
                    ConsistentHash consistentHash = new ConsistentHash(LocalDataServerCleanHandler.this.dataServerBootstrapConfig.getNumberOfReplicas(), dataNodeMap.values());
                    Map<String, Map<String, Datum>> dataMapAll = DatumCache.getAll();
                    for (Map.Entry<String, Map<String, Datum>> entryAll : dataMapAll.entrySet()) {
                        String dataCenter = entryAll.getKey();
                        Map<String, Datum> dataMap = entryAll.getValue();
                        for (Map.Entry<String, Datum> entry : dataMap.entrySet()) {
                            String dataInfoId = entry.getKey();
                            Datum datum = entry.getValue();
                            if (!this.running.get()) {
                                LOGGER.info("[LocalDataServerCleanHandler] task cancel, dataInfoId={}", (Object)dataInfoId);
                                return;
                            }
                            BackupTriad backupTriad = new BackupTriad(dataInfoId, consistentHash.getNUniqueNodesFor((Object)dataInfoId, LocalDataServerCleanHandler.this.dataServerBootstrapConfig.getStoreNodes()));
                            if (backupTriad.containsSelf() || datum == null) continue;
                            int size = datum.getPubMap() != null ? datum.getPubMap().size() : 0;
                            LocalDataServerCleanHandler.this.dataChangeEventCenter.clean(datum, DataSourceTypeEnum.CLEAN);
                            LOGGER.info("[LocalDataServerCleanHandler] clean handle, dataCenter={},dataInfoId={},pub size={}", new Object[]{dataCenter, dataInfoId, size});
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("[LocalDataServerCleanHandler] clean local datum task error!", e);
                }
                finally {
                    LocalDataServerCleanHandler.this.EVENT_QUEUE.add(new DelayItem<LocalCleanTask>(new LocalCleanTask(), LocalDataServerCleanHandler.this.dataServerBootstrapConfig.getLocalDataServerCleanDelay()));
                }
            }
        }

        public void stop() {
            this.running.set(false);
        }
    }
}

