/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.bootstrap;

import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.data.bootstrap.CommonConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="data.server")
public class DataServerConfig {
    public static final String PRE_FIX = "data.server";
    public static final String IP = NetUtil.getLocalAddress().getHostAddress();
    private int port;
    private int syncDataPort;
    private int metaServerPort;
    private int httpServerPort;
    private int queueCount;
    private int queueSize;
    private int notifyIntervalMs;
    private int clientOffDelayMs;
    private int rpcTimeout;
    private CommonConfig commonConfig;
    private Set<String> metaIps = null;
    private int storeNodes = 3;
    private int numberOfReplicas = 1000;
    private long localDataServerCleanDelay = 1800000L;
    private int getDataExecutorMinPoolSize = 80;
    private int getDataExecutorMaxPoolSize = 400;
    private int getDataExecutorQueueSize = 10000;
    private long getDataExecutorKeepAliveTime = 60L;
    private int notifyDataSyncExecutorMinPoolSize = 80;
    private int notifyDataSyncExecutorMaxPoolSize = 400;
    private int notifyDataSyncExecutorQueueSize = 700;
    private long notifyDataSyncExecutorKeepAliveTime = 60L;
    private long notifySessionRetryFirstDelay = 1000L;
    private long notifySessionRetryIncrementDelay = 1000L;
    private int notifySessionRetryTimes = 10;
    private int publishExecutorMinPoolSize = 80;
    private int publishExecutorMaxPoolSize = 400;
    private int publishExecutorQueueSize = 10000;

    public DataServerConfig(CommonConfig commonConfig) {
        this.commonConfig = commonConfig;
    }

    public String getLocalDataCenter() {
        return this.commonConfig.getLocalDataCenter();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSyncDataPort() {
        return this.syncDataPort;
    }

    public void setSyncDataPort(int syncDataPort) {
        this.syncDataPort = syncDataPort;
    }

    public int getMetaServerPort() {
        return this.metaServerPort;
    }

    public void setMetaServerPort(int metaServerPort) {
        this.metaServerPort = metaServerPort;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    public int getQueueCount() {
        return this.queueCount;
    }

    public void setQueueCount(int queueCount) {
        this.queueCount = queueCount;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getNotifyIntervalMs() {
        return this.notifyIntervalMs;
    }

    public void setNotifyIntervalMs(int notifyIntervalMs) {
        this.notifyIntervalMs = notifyIntervalMs;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public int getStoreNodes() {
        return this.storeNodes;
    }

    public void setStoreNodes(int storeNodes) {
        this.storeNodes = storeNodes;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public long getLocalDataServerCleanDelay() {
        return this.localDataServerCleanDelay;
    }

    public void setLocalDataServerCleanDelay(long localDataServerCleanDelay) {
        this.localDataServerCleanDelay = localDataServerCleanDelay;
    }

    public int getGetDataExecutorMinPoolSize() {
        return this.getDataExecutorMinPoolSize;
    }

    public int getGetDataExecutorMaxPoolSize() {
        return this.getDataExecutorMaxPoolSize;
    }

    public int getGetDataExecutorQueueSize() {
        return this.getDataExecutorQueueSize;
    }

    public long getGetDataExecutorKeepAliveTime() {
        return this.getDataExecutorKeepAliveTime;
    }

    public void setGetDataExecutorMinPoolSize(int getDataExecutorMinPoolSize) {
        this.getDataExecutorMinPoolSize = getDataExecutorMinPoolSize;
    }

    public void setGetDataExecutorMaxPoolSize(int getDataExecutorMaxPoolSize) {
        this.getDataExecutorMaxPoolSize = getDataExecutorMaxPoolSize;
    }

    public void setGetDataExecutorQueueSize(int getDataExecutorQueueSize) {
        this.getDataExecutorQueueSize = getDataExecutorQueueSize;
    }

    public void setGetDataExecutorKeepAliveTime(long getDataExecutorKeepAliveTime) {
        this.getDataExecutorKeepAliveTime = getDataExecutorKeepAliveTime;
    }

    public int getNotifyDataSyncExecutorMinPoolSize() {
        return this.notifyDataSyncExecutorMinPoolSize;
    }

    public void setNotifyDataSyncExecutorMinPoolSize(int notifyDataSyncExecutorMinPoolSize) {
        this.notifyDataSyncExecutorMinPoolSize = notifyDataSyncExecutorMinPoolSize;
    }

    public int getNotifyDataSyncExecutorMaxPoolSize() {
        return this.notifyDataSyncExecutorMaxPoolSize;
    }

    public void setNotifyDataSyncExecutorMaxPoolSize(int notifyDataSyncExecutorMaxPoolSize) {
        this.notifyDataSyncExecutorMaxPoolSize = notifyDataSyncExecutorMaxPoolSize;
    }

    public int getNotifyDataSyncExecutorQueueSize() {
        return this.notifyDataSyncExecutorQueueSize;
    }

    public void setNotifyDataSyncExecutorQueueSize(int notifyDataSyncExecutorQueueSize) {
        this.notifyDataSyncExecutorQueueSize = notifyDataSyncExecutorQueueSize;
    }

    public long getNotifyDataSyncExecutorKeepAliveTime() {
        return this.notifyDataSyncExecutorKeepAliveTime;
    }

    public void setNotifyDataSyncExecutorKeepAliveTime(long notifyDataSyncExecutorKeepAliveTime) {
        this.notifyDataSyncExecutorKeepAliveTime = notifyDataSyncExecutorKeepAliveTime;
    }

    public long getNotifySessionRetryFirstDelay() {
        return this.notifySessionRetryFirstDelay;
    }

    public void setNotifySessionRetryFirstDelay(long notifySessionRetryFirstDelay) {
        this.notifySessionRetryFirstDelay = notifySessionRetryFirstDelay;
    }

    public long getNotifySessionRetryIncrementDelay() {
        return this.notifySessionRetryIncrementDelay;
    }

    public void setNotifySessionRetryIncrementDelay(long notifySessionRetryIncrementDelay) {
        this.notifySessionRetryIncrementDelay = notifySessionRetryIncrementDelay;
    }

    public int getClientOffDelayMs() {
        return this.clientOffDelayMs;
    }

    public void setClientOffDelayMs(int clientOffDelayMs) {
        this.clientOffDelayMs = clientOffDelayMs;
    }

    public int getPublishExecutorMinPoolSize() {
        return this.publishExecutorMinPoolSize;
    }

    public void setPublishExecutorMinPoolSize(int publishExecutorMinPoolSize) {
        this.publishExecutorMinPoolSize = publishExecutorMinPoolSize;
    }

    public int getPublishExecutorMaxPoolSize() {
        return this.publishExecutorMaxPoolSize;
    }

    public void setPublishExecutorMaxPoolSize(int publishExecutorMaxPoolSize) {
        this.publishExecutorMaxPoolSize = publishExecutorMaxPoolSize;
    }

    public int getPublishExecutorQueueSize() {
        return this.publishExecutorQueueSize;
    }

    public void setPublishExecutorQueueSize(int publishExecutorQueueSize) {
        this.publishExecutorQueueSize = publishExecutorQueueSize;
    }

    public Set<String> getMetaServerIpAddresses() {
        Collection<String> metas;
        String localDataCenter;
        Map<String, Collection<String>> metaMap;
        if (this.metaIps != null && !this.metaIps.isEmpty()) {
            return this.metaIps;
        }
        this.metaIps = new HashSet<String>();
        if (!(this.commonConfig == null || (metaMap = this.commonConfig.getMetaNode()) == null || metaMap.isEmpty() || (localDataCenter = this.commonConfig.getLocalDataCenter()) == null || localDataCenter.isEmpty() || (metas = metaMap.get(localDataCenter)) == null || metas.isEmpty())) {
            this.metaIps = metas.stream().map(NetUtil::getIPAddressFromDomain).collect(Collectors.toSet());
        }
        return this.metaIps;
    }

    public int getNotifySessionRetryTimes() {
        return this.notifySessionRetryTimes;
    }

    public void setNotifySessionRetryTimes(int notifySessionRetryTimes) {
        this.notifySessionRetryTimes = notifySessionRetryTimes;
    }
}

