/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.bootstrap;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.datasync.sync.Scheduler;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import com.alipay.sofa.registry.server.data.event.MetaServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.StartTaskEvent;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.data.remoting.metaserver.IMetaServerService;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;

@EnableConfigurationProperties
public class DataServerBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServerBootstrap.class);
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Autowired
    private IMetaServerService metaServerService;
    @Autowired
    private Scheduler syncDataScheduler;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ResourceConfig jerseyResourceConfig;
    @Autowired
    private Exchange jerseyExchange;
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private EventCenter eventCenter;
    @Resource(name="serverHandlers")
    private Collection<AbstractServerHandler> serverHandlers;
    @Resource(name="serverSyncHandlers")
    private Collection<AbstractServerHandler> serverSyncHandlers;
    private Server server;
    private Server dataSyncServer;
    private Server httpServer;
    private AtomicBoolean httpServerStarted = new AtomicBoolean(false);
    private AtomicBoolean schedulerStarted = new AtomicBoolean(false);
    private AtomicBoolean serverForSessionStarted = new AtomicBoolean(false);
    private AtomicBoolean serverForDataSyncStarted = new AtomicBoolean(false);

    public void start() {
        try {
            LOGGER.info("[DataServerBootstrap] begin start server");
            this.openDataServer();
            this.openDataSyncServer();
            this.openHttpServer();
            this.startRaftClient();
            this.startScheduler();
            Runtime.getRuntime().addShutdownHook(new Thread(this::doStop));
            LOGGER.info("[DataServerBootstrap] start server success");
        }
        catch (Exception e) {
            throw new RuntimeException("[DataServerBootstrap] start server error", e);
        }
    }

    private void openDataServer() {
        try {
            if (this.serverForSessionStarted.compareAndSet(false, true)) {
                this.server = this.boltExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.dataServerBootstrapConfig.getPort()), (Object[])this.serverHandlers.toArray(new ChannelHandler[this.serverHandlers.size()]));
                LOGGER.info("Data server for session started! port:{}", (Object)this.dataServerBootstrapConfig.getPort());
            }
        }
        catch (Exception e) {
            this.serverForSessionStarted.set(false);
            LOGGER.error("Data server start error! port:{}", (Object)this.dataServerBootstrapConfig.getPort(), (Object)e);
            throw new RuntimeException("Data server start error!", e);
        }
    }

    private void openDataSyncServer() {
        try {
            if (this.serverForDataSyncStarted.compareAndSet(false, true)) {
                this.dataSyncServer = this.boltExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.dataServerBootstrapConfig.getSyncDataPort()), (Object[])this.serverSyncHandlers.toArray(new ChannelHandler[this.serverSyncHandlers.size()]));
                LOGGER.info("Data server for sync started! port:{}", (Object)this.dataServerBootstrapConfig.getSyncDataPort());
            }
        }
        catch (Exception e) {
            this.serverForDataSyncStarted.set(false);
            LOGGER.error("Data sync server start error! port:{}", (Object)this.dataServerBootstrapConfig.getSyncDataPort(), (Object)e);
            throw new RuntimeException("Data sync server start error!", e);
        }
    }

    private void openHttpServer() {
        try {
            if (this.httpServerStarted.compareAndSet(false, true)) {
                this.bindResourceConfig();
                this.httpServer = this.jerseyExchange.open(new URL(NetUtil.getLocalAddress().getHostAddress(), this.dataServerBootstrapConfig.getHttpServerPort()), (Object[])new ResourceConfig[]{this.jerseyResourceConfig});
                LOGGER.info("Open http server port {} success!", (Object)this.dataServerBootstrapConfig.getHttpServerPort());
            }
        }
        catch (Exception e) {
            this.httpServerStarted.set(false);
            LOGGER.error("Open http server port {} error!", (Object)this.dataServerBootstrapConfig.getHttpServerPort(), (Object)e);
            throw new RuntimeException("Open http server  error!", e);
        }
    }

    private void startRaftClient() {
        this.metaServerService.startRaftClient();
        this.eventCenter.post(new MetaServerChangeEvent(this.metaServerService.getMetaServerMap()));
        LOGGER.info("[DataServerBootstrap] raft client started!Leader is {}", (Object)this.metaServerService.getLeader());
    }

    private void startScheduler() {
        try {
            if (this.schedulerStarted.compareAndSet(false, true)) {
                this.syncDataScheduler.startScheduler();
                this.eventCenter.post(StartTaskEvent.getInstance());
            }
        }
        catch (Exception e) {
            this.schedulerStarted.set(false);
            LOGGER.error("Data Scheduler start error!", (Throwable)e);
            throw new RuntimeException("Data Scheduler start error!", e);
        }
    }

    public void destroy() {
        this.doStop();
    }

    private void doStop() {
        try {
            LOGGER.info("{} Shutting down Data Server..", (Object)new Date().toString());
            if (this.httpServer != null && this.httpServer.isOpen()) {
                this.httpServer.close();
            }
            if (this.server != null && this.server.isOpen()) {
                this.server.close();
            }
            if (this.dataSyncServer != null && this.dataSyncServer.isOpen()) {
                this.dataSyncServer.close();
            }
            if (this.syncDataScheduler != null) {
                this.syncDataScheduler.stopScheduler();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Shutting down Data Server error!", e);
        }
        LOGGER.info("{} Data server is now shutdown...", (Object)new Date().toString());
    }

    private void bindResourceConfig() {
        this.registerInstances(Path.class);
        this.registerInstances(Provider.class);
    }

    private void registerInstances(Class<? extends Annotation> annotationType) {
        Map beans = this.applicationContext.getBeansWithAnnotation(annotationType);
        if (beans != null && !beans.isEmpty()) {
            beans.forEach((beanName, bean) -> this.jerseyResourceConfig.registerInstances(new Object[]{bean}));
        }
    }

    public AtomicBoolean getHttpServerStarted() {
        return this.httpServerStarted;
    }

    public AtomicBoolean getSchedulerStarted() {
        return this.schedulerStarted;
    }

    public AtomicBoolean getServerForSessionStarted() {
        return this.serverForSessionStarted;
    }

    public AtomicBoolean getServerForDataSyncStarted() {
        return this.serverForDataSyncStarted;
    }
}

