/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.jersey;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.jersey.jetty.server.HttpConnectionCustomFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.jetty.JettyHttpContainer;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyJettyServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyJettyServer.class);
    private final ResourceConfig resourceConfig;
    private final URI baseUri;
    private org.eclipse.jetty.server.Server server;
    private AtomicBoolean isStarted = new AtomicBoolean(false);

    public JerseyJettyServer(ResourceConfig resourceConfig, URI baseUri) {
        this.resourceConfig = resourceConfig;
        this.baseUri = baseUri;
    }

    public void startServer() {
        if (this.isStarted.compareAndSet(false, true)) {
            try {
                this.server = JerseyJettyServer.createServer(this.getBaseUri(), this.resourceConfig, true);
            }
            catch (Exception e) {
                this.isStarted.set(false);
                LOGGER.error("Start Jetty jersey server error!", (Throwable)e);
                throw new RuntimeException("Start Jetty jersey server error!", e);
            }
        }
    }

    public static org.eclipse.jetty.server.Server createServer(URI uri, ResourceConfig resourceConfig, boolean start) {
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.URI_CANNOT_BE_NULL());
        }
        JettyHttpContainer handler = (JettyHttpContainer)ContainerFactory.createContainer(JettyHttpContainer.class, (Application)resourceConfig);
        int defaultPort = 80;
        int port = uri.getPort() == -1 ? defaultPort : uri.getPort();
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server((ThreadPool)new JettyConnectorThreadPool());
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionCustomFactory()});
        http.setPort(port);
        server.setConnectors(new Connector[]{http});
        if (handler != null) {
            server.setHandler((Handler)handler);
        }
        if (start) {
            try {
                server.start();
            }
            catch (Exception e) {
                throw new ProcessingException(LocalizationMessages.ERROR_WHEN_CREATING_SERVER(), (Throwable)e);
            }
        }
        return server;
    }

    public boolean isOpen() {
        if (this.server != null) {
            return this.server.isStarted();
        }
        return false;
    }

    public Collection<Channel> getChannels() {
        return null;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return null;
    }

    public Channel getChannel(URL url) {
        return null;
    }

    public void close(Channel channel) {
        throw new UnsupportedOperationException("Jersey Server don't support close Channel.");
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.getBaseUri().getPort());
    }

    public void close() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOGGER.error("Jersey Jetty Server stop error!", (Throwable)e);
                throw new RuntimeException("Jersey Jetty Server stop error!", e);
            }
            return;
        }
        throw new RuntimeException("Jersey Server has not started!Server Channel has not created!");
    }

    public boolean isClosed() {
        if (this.server != null) {
            return this.server.isStopped();
        }
        return true;
    }

    public Object sendSync(Channel channel, Object message, int timeoutMillis) {
        return null;
    }

    public void sendCallback(Channel channel, Object message, CallbackHandler callbackHandler, int timeoutMillis) {
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public int getChannelCount() {
        return 0;
    }

    private static final class JettyConnectorThreadPool
    extends QueuedThreadPool {
        private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("jetty-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build();

        private JettyConnectorThreadPool() {
        }

        protected Thread newThread(Runnable runnable) {
            return this.threadFactory.newThread(runnable);
        }
    }
}

