/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.remoting.bolt.exchange;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.bolt.BoltClient;
import com.alipay.sofa.registry.remoting.bolt.BoltServer;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BoltExchange
implements Exchange<ChannelHandler> {
    private Map<String, Client> clients = new ConcurrentHashMap<String, Client>();
    private ConcurrentHashMap<Integer, Server> serverMap = new ConcurrentHashMap();

    public Client connect(String serverType, URL serverUrl, ChannelHandler ... channelHandlers) {
        if (channelHandlers == null) {
            throw new IllegalArgumentException("channelHandlers cannot be null!");
        }
        Client client = this.clients.get(serverType);
        if (client == null) {
            BoltClient boltClient = new BoltClient();
            boltClient.setChannelHandlers(Arrays.asList(channelHandlers));
            boltClient.connect(serverUrl);
            client = this.clients.putIfAbsent(serverType, boltClient);
            if (client == null) {
                client = boltClient;
            }
        } else {
            Channel channel = client.getChannel(serverUrl);
            if (channel == null) {
                BoltClient boltClient = (BoltClient)client;
                boltClient.setChannelHandlers(Arrays.asList(channelHandlers));
                boltClient.connect(serverUrl);
            }
        }
        return client;
    }

    public Server open(URL url, ChannelHandler ... channelHandlers) {
        if (channelHandlers == null) {
            throw new IllegalArgumentException("channelHandlers cannot be null!");
        }
        BoltServer server = new BoltServer(url, Arrays.asList(channelHandlers));
        this.setServer(server, url);
        server.startServer();
        return server;
    }

    public Client getClient(String serverType) {
        return this.clients.get(serverType);
    }

    public Server getServer(Integer port) {
        return this.serverMap.get(port);
    }

    public void setServer(Server server, URL url) {
        this.serverMap.putIfAbsent(url.getPort(), server);
    }
}

