/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.timer;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncHashedWheelTimer
extends HashedWheelTimer {
    protected final Executor executor;
    protected final TaskFailedCallback taskFailedCallback;

    public AsyncHashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, int threadSize, int queueSize, ThreadFactory asyncThreadFactory, TaskFailedCallback taskFailedCallback) {
        super(threadFactory, tickDuration, unit, ticksPerWheel);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadSize, threadSize, 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), asyncThreadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.executor = threadPoolExecutor;
        this.taskFailedCallback = taskFailedCallback;
    }

    public AsyncHashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, Executor asyncExecutor, TaskFailedCallback taskFailedCallback) {
        super(threadFactory, tickDuration, unit, ticksPerWheel);
        this.executor = asyncExecutor;
        this.taskFailedCallback = taskFailedCallback;
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return super.newTimeout((TimerTask)new AsyncTimerTask(task), delay, unit);
    }

    public static interface TaskFailedCallback {
        public void executionRejected(Throwable var1);

        public void executionFailed(Throwable var1);
    }

    class AsyncTimerTask
    implements TimerTask,
    Runnable {
        TimerTask timerTask;
        Timeout timeout;

        public AsyncTimerTask(TimerTask timerTask) {
            this.timerTask = timerTask;
        }

        public void run(Timeout timeout) {
            this.timeout = timeout;
            try {
                AsyncHashedWheelTimer.this.executor.execute(this);
            }
            catch (RejectedExecutionException e) {
                AsyncHashedWheelTimer.this.taskFailedCallback.executionRejected(e);
            }
            catch (Throwable e) {
                AsyncHashedWheelTimer.this.taskFailedCallback.executionFailed(e);
            }
        }

        @Override
        public void run() {
            try {
                this.timerTask.run(this.timeout);
            }
            catch (Throwable e) {
                AsyncHashedWheelTimer.this.taskFailedCallback.executionFailed(e);
            }
        }
    }
}

