/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.task.batcher;

import com.alipay.sofa.registry.task.batcher.AcceptorExecutor;
import com.alipay.sofa.registry.task.batcher.TaskDispatcher;
import com.alipay.sofa.registry.task.batcher.TaskExecutors;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaskDispatchers {
    private static Map<String, TaskDispatcher> taskDispatcherMap = new ConcurrentHashMap<String, TaskDispatcher>();
    private static final String TASK_DISPATCHER_END = "Dispatcher";

    public static <ID, T> TaskDispatcher<ID, T> createDefaultSingleTaskDispatcher(String id, TaskProcessor<T> taskProcessor) {
        String name = TaskDispatchers.getDispatcherName(id);
        TaskDispatcher taskDispatcher = taskDispatcherMap.computeIfAbsent(name, k -> {
            final AcceptorExecutor acceptorExecutor = new AcceptorExecutor(name, 1000, 1000L, 100L);
            final TaskExecutors taskExecutor = TaskExecutors.createTaskExecutors(name, 20, taskProcessor, acceptorExecutor);
            return new TaskDispatcher<ID, T>(){

                @Override
                public void dispatch(ID id, T task, long expiryTime) {
                    acceptorExecutor.process(id, task, expiryTime);
                }

                @Override
                public void shutdown() {
                    acceptorExecutor.shutdown();
                    taskExecutor.shutdown();
                }

                @Override
                public AcceptorExecutor<ID, T> getAcceptorExecutor() {
                    return acceptorExecutor;
                }
            };
        });
        return taskDispatcher;
    }

    public static void stopDefaultSingleTaskDispatcher() {
        taskDispatcherMap.forEach((k, v) -> {
            if (v != null) {
                v.shutdown();
            }
        });
    }

    public static <ID, T> TaskDispatcher<ID, T> createSingleTaskDispatcher(String id, int maxBufferSize, int workerCount, long congestionRetryDelayMs, long networkFailureRetryMs, TaskProcessor<T> taskProcessor) {
        return taskDispatcherMap.computeIfAbsent(id, k -> {
            final AcceptorExecutor acceptorExecutor = new AcceptorExecutor(id, maxBufferSize, congestionRetryDelayMs, networkFailureRetryMs);
            final TaskExecutors taskExecutor = TaskExecutors.createTaskExecutors(id, workerCount, taskProcessor, acceptorExecutor);
            return new TaskDispatcher<ID, T>(){

                @Override
                public void dispatch(ID id, T task, long expiryTime) {
                    acceptorExecutor.process(id, task, expiryTime);
                }

                @Override
                public void shutdown() {
                    acceptorExecutor.shutdown();
                    taskExecutor.shutdown();
                }

                @Override
                public AcceptorExecutor<ID, T> getAcceptorExecutor() {
                    return acceptorExecutor;
                }
            };
        });
    }

    public static String getDispatcherName(String name) {
        return name + TASK_DISPATCHER_END;
    }

    public static Map<String, TaskDispatcher> getTaskDispatcherMap() {
        return taskDispatcherMap;
    }
}

