/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.log;

import com.alipay.sofa.registry.log.Logger;
import java.io.File;
import java.io.Serializable;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
implements Logger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LOG_PATH = "logging.path";
    private static final String LOG_PATH_DEFAULT = System.getProperty("user.home") + File.separator + "logs";
    private static final String SERVER_LOG_LEVEL = "com.alipay.sofa.registry.server.log.level";
    private static final String SERVER_LOG_LEVEL_DEFAULT = "INFO";
    private final String name;
    private final org.slf4j.Logger logger;
    private final String msgPrefix;
    public static final char SPACE = ' ';

    public SLF4JLogger(String name) {
        this.name = name;
        this.msgPrefix = "";
        this.logger = this.getLoggerBySpace(name);
    }

    public SLF4JLogger(Class clazz) {
        this.name = clazz.getCanonicalName();
        this.msgPrefix = "";
        this.logger = this.getLoggerBySpace(this.name);
    }

    public SLF4JLogger(String name, String msgPrefix) {
        this.name = name;
        this.msgPrefix = msgPrefix;
        this.logger = this.getLoggerBySpace(name);
    }

    public SLF4JLogger(Class clazz, String msgPrefix) {
        this.name = clazz.getCanonicalName();
        this.msgPrefix = msgPrefix;
        this.logger = this.getLoggerBySpace(this.name);
    }

    public org.slf4j.Logger getLoggerBySpace(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return LoggerFactory.getLogger((String)name);
    }

    @Override
    public void trace(String msg) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.processMsg(msg));
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.processMsg(format), arg);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.processMsg(format), arg1, arg2);
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.processMsg(format), arguments);
        }
    }

    @Override
    public void trace(String msg, Throwable e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.processMsg(msg), e);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.processMsg(msg));
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.processMsg(format), arg);
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.processMsg(format), arg1, arg2);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.processMsg(format), arguments);
        }
    }

    @Override
    public void debug(String msg, Throwable e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.processMsg(msg), e);
        }
    }

    @Override
    public void info(String msg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.processMsg(msg));
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.processMsg(format), arg);
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.processMsg(format), arg1, arg2);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.processMsg(format), arguments);
        }
    }

    @Override
    public void info(String msg, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.processMsg(msg), e);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.processMsg(msg));
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.processMsg(format), arg);
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.processMsg(format), arguments);
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.processMsg(format), arg1, arg2);
        }
    }

    @Override
    public void warn(String msg, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.processMsg(msg), e);
        }
    }

    @Override
    public void error(String msg) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.processMsg(msg));
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.processMsg(format), arg);
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.processMsg(format), arg1, arg2);
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.processMsg(format), arguments);
        }
    }

    @Override
    public void error(String msg, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.processMsg(msg), e);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    private String processMsg(String msg) {
        if (this.msgPrefix.isEmpty()) {
            return msg;
        }
        return this.msgPrefix + ' ' + msg;
    }

    @Override
    public Object getLogger() {
        return this.logger;
    }

    static {
        String logPath = System.getProperty(LOG_PATH);
        String logLevel = System.getProperty(SERVER_LOG_LEVEL);
        if (logPath == null || logPath.isEmpty()) {
            System.setProperty(LOG_PATH, LOG_PATH_DEFAULT);
        }
        if (logLevel == null || logLevel.isEmpty()) {
            System.setProperty(SERVER_LOG_LEVEL, SERVER_LOG_LEVEL_DEFAULT);
        }
    }
}

