/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.store;

import com.alipay.sofa.registry.common.model.constants.ValueConstants;
import java.io.Serializable;

public class DataInfo
implements Serializable {
    private String dataInfoId;
    private String instanceId;
    private String dataId;
    private String dataType;
    public static final String DELIMITER = "#@#";
    public static final int DATAID_LENTH = 3;

    public DataInfo(String instanceId, String dataId, String dataType) {
        this.instanceId = instanceId;
        this.dataId = dataId;
        this.dataType = dataType;
        this.dataInfoId = DataInfo.toDataInfoId(dataId, instanceId, dataType);
    }

    public static String toDataInfoId(String dataId, String instanceId, String dataType) {
        StringBuilder buf = new StringBuilder();
        if (dataId == null || dataId.isEmpty()) {
            throw new IllegalArgumentException("error dataId:" + dataId);
        }
        if (ValueConstants.DISABLE_DATA_ID_CASE_SENSITIVE.booleanValue()) {
            buf.append(dataId.toUpperCase());
        } else {
            buf.append(dataId);
        }
        if (instanceId == null || instanceId.isEmpty()) {
            throw new IllegalArgumentException("error instanceId:" + instanceId);
        }
        buf.append(DELIMITER).append(instanceId);
        if (dataType == null || dataType.isEmpty()) {
            throw new IllegalArgumentException("error dataType:" + dataType);
        }
        buf.append(DELIMITER).append(dataType);
        return buf.toString();
    }

    public static DataInfo valueOf(String dataInfoId) {
        if (dataInfoId == null || dataInfoId.isEmpty()) {
            throw new IllegalArgumentException("dataInfoId null");
        }
        String[] str = dataInfoId.split(DELIMITER);
        if (str.length != 3) {
            throw new IllegalArgumentException("dataInfoId input error!");
        }
        return new DataInfo(str[1], str[0], str[2]);
    }

    public String getDataInfoId() {
        return this.dataInfoId;
    }

    public void setDataInfoId(String dataInfoId) {
        this.dataInfoId = dataInfoId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}

