/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.store;

import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.common.model.store.WordCache;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseInfo
implements Serializable,
StoreData<String> {
    private static final long serialVersionUID = -6263388188316303789L;
    private String dataInfoId;
    private String dataId;
    private String clientId;
    private String instanceId;
    private String cell;
    private String appName;
    private String processId;
    private String registerId;
    private Long version;
    private URL sourceAddress;
    private ClientVersion clientVersion;
    private String group;
    private long registerTimestamp;
    private long clientRegisterTimestamp;
    private Map<String, String> attributes = new HashMap<String, String>();

    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = WordCache.getInstance().getWordCache(cell);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = WordCache.getInstance().getWordCache(appName);
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = WordCache.getInstance().getWordCache(processId);
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public URL getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(URL sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        if (attributes != null && !attributes.isEmpty()) {
            attributes.forEach((key, value) -> newAttributes.put((String)key, (String)value));
        }
        this.attributes = newAttributes;
    }

    public String getDataInfoId() {
        return this.dataInfoId;
    }

    public void setDataInfoId(String dataInfoId) {
        this.dataInfoId = WordCache.getInstance().getWordCache(dataInfoId);
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.registerId;
    }

    public String getRegisterId() {
        return this.registerId;
    }

    public void setRegisterId(String registerId) {
        this.registerId = registerId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = WordCache.getInstance().getWordCache(dataId);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = WordCache.getInstance().getWordCache(clientId);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = WordCache.getInstance().getWordCache(instanceId);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = WordCache.getInstance().getWordCache(group);
    }

    public long getRegisterTimestamp() {
        return this.registerTimestamp;
    }

    public void setRegisterTimestamp(long registerTimestamp) {
        this.registerTimestamp = registerTimestamp;
    }

    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public long getClientRegisterTimestamp() {
        return this.clientRegisterTimestamp;
    }

    public void setClientRegisterTimestamp(long clientRegisterTimestamp) {
        this.clientRegisterTimestamp = clientRegisterTimestamp;
    }

    protected String getOtherInfo() {
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getDataType().toString());
        sb.append("{dataInfoId='").append(this.dataInfoId).append('\'');
        sb.append(", clientId='").append(this.clientId).append('\'');
        sb.append(", cell='").append(this.cell).append('\'');
        sb.append(", appName='").append(this.appName).append('\'');
        sb.append(", processId='").append(this.processId).append('\'');
        sb.append(", registerId='").append(this.registerId).append('\'');
        sb.append(", version=").append(this.version);
        sb.append(", sourceAddress=").append(this.sourceAddress);
        sb.append(", clientVersion=").append((Object)this.clientVersion);
        sb.append(", registerTimestamp=").append(this.registerTimestamp);
        sb.append(", clientRegisterTimestamp=").append(this.clientRegisterTimestamp);
        sb.append(", otherInfo=").append(this.getOtherInfo());
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    public static enum ClientVersion {
        ProtocolPackage("1.x"),
        NProtocolpackage("2.x"),
        MProtocolpackage("3.x"),
        StoreData("4.x");

        private String version;

        private ClientVersion(String version) {
            this.version = version;
        }
    }
}

