/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.store;

import com.alipay.sofa.registry.common.model.store.WordCache;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;

public final class URL
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(URL.class);
    public static final char COLON = ':';
    public static final byte HESSIAN_2 = 1;
    public static final byte PROTOBUF = 11;
    public static final byte JSON = 2;
    private ProtocolType protocol;
    private String host;
    private String ipAddress;
    private int port;
    private String path;
    private Byte serializerIndex;
    private Map<String, String> parameters;
    private String addressString;

    public URL() {
    }

    public URL(ProtocolType protocol, String ipAddress, int port, String host, String path, Byte serializerIndex, Map<String, String> parameters) {
        this.protocol = protocol;
        this.host = host;
        this.ipAddress = WordCache.getInstance().getWordCache(this.getIPAddressFromDomain(ipAddress));
        this.port = port;
        this.addressString = WordCache.getInstance().getWordCache(this.buildAddressString());
        this.path = path;
        this.serializerIndex = serializerIndex;
        this.parameters = parameters;
    }

    public URL(String ipAddress, int port) {
        this(null, ipAddress, port, "", "", (byte)1, null);
    }

    public URL(InetSocketAddress address) {
        this(null, address.getAddress().getHostAddress(), address.getPort(), "", "", (byte)1, null);
    }

    public URL(InetSocketAddress address, Byte serializerIndex) {
        this(null, address.getAddress().getHostAddress(), address.getPort(), "", "", serializerIndex, null);
    }

    public URL(String ipAddress) {
        this(ipAddress, 0);
    }

    public static InetSocketAddress toInetSocketAddress(URL url) {
        return new InetSocketAddress(url.getIpAddress(), url.getPort());
    }

    public ProtocolType getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public String buildAddressString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ipAddress).append(':').append(this.port);
        return sb.toString();
    }

    public Byte getSerializerIndex() {
        return this.serializerIndex;
    }

    private String getIPAddressFromDomain(String domain) {
        try {
            InetAddress a = InetAddress.getByName(domain);
            return a.getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error("Can not resolve " + domain + " really ip.");
            return domain;
        }
    }

    public static URL valueOf(String url) {
        if (url == null || (url = url.trim()).length() == 0) {
            throw new IllegalArgumentException("url == null");
        }
        String ipAddress = "";
        String path = "";
        int port = 0;
        ProtocolType protocol = null;
        Map<String, String> parameters = null;
        int i = url.indexOf(":");
        if (i >= 0 && i < url.length() - 1) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            ipAddress = url;
        }
        return new URL(protocol, ipAddress, port, "", path, (byte)1, parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("URL{");
        sb.append("address='").append(this.addressString).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static enum ProtocolType {
        TR,
        BOLT,
        HTTP;

    }
}

