/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.api.SubscriberDataObserver;
import com.alipay.sofa.registry.client.api.model.UserData;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.client.model.SegmentData;
import com.alipay.sofa.registry.client.provider.AbstractInternalRegister;
import com.alipay.sofa.registry.client.provider.DefaultUserData;
import com.alipay.sofa.registry.client.task.TaskEvent;
import com.alipay.sofa.registry.client.task.Worker;
import com.alipay.sofa.registry.client.util.CommonUtils;
import com.alipay.sofa.registry.client.util.StringUtils;
import com.alipay.sofa.registry.core.model.DataBox;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.alipay.sofa.registry.core.model.SubscriberRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultSubscriber
extends AbstractInternalRegister
implements Subscriber {
    private final String REGIST_ID;
    private SubscriberDataObserver dataObserver;
    private ConcurrentHashMap<String, SegmentData> data = new ConcurrentHashMap();
    private AtomicBoolean init = new AtomicBoolean(false);
    private RegistryClientConfig config;
    private SubscriberRegistration registration;
    private Worker worker;
    private volatile String localZone;
    private List<String> availableSegments = new ArrayList<String>();

    DefaultSubscriber(SubscriberRegistration registration, Worker worker, RegistryClientConfig config) {
        if (null != registration) {
            this.dataObserver = registration.getSubscriberDataObserver();
        }
        this.registration = registration;
        this.worker = worker;
        this.config = config;
        this.REGIST_ID = UUID.randomUUID().toString();
        this.localZone = config.getZone();
        this.getPubVersion().incrementAndGet();
    }

    @Override
    public SubscriberDataObserver getDataObserver() {
        return this.dataObserver;
    }

    @Override
    public void setDataObserver(SubscriberDataObserver dataObserver) {
        this.dataObserver = dataObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserData peekData() {
        this.readLock.lock();
        try {
            if (!this.init.get()) {
                DefaultUserData defaultUserData = new DefaultUserData();
                return defaultUserData;
            }
            Set<Map.Entry<String, SegmentData>> values = this.data.entrySet();
            DefaultUserData userData = new DefaultUserData();
            if (null == this.localZone) {
                userData.setLocalZone(this.config.getZone());
            } else {
                userData.setLocalZone(this.localZone);
            }
            HashMap<String, List<String>> zoneMap = new HashMap<String, List<String>>();
            for (Map.Entry<String, SegmentData> segmentDataEntry : values) {
                SegmentData segmentData;
                String segment = segmentDataEntry.getKey();
                if (CommonUtils.isNotEmpty(this.availableSegments) && !this.availableSegments.contains(segment) || null == (segmentData = segmentDataEntry.getValue())) continue;
                Map<String, List<DataBox>> data = segmentData.getData();
                for (Map.Entry<String, List<DataBox>> entry : data.entrySet()) {
                    String zone = entry.getKey();
                    ArrayList<String> resultList = (ArrayList<String>)zoneMap.get(zone);
                    if (null == resultList) {
                        resultList = new ArrayList<String>();
                        zoneMap.put(zone, resultList);
                    }
                    List<DataBox> dataList = entry.getValue();
                    for (DataBox dataBox : dataList) {
                        resultList.add(dataBox.getData());
                    }
                }
            }
            userData.setZoneData(zoneMap);
            DefaultUserData defaultUserData = userData;
            return defaultUserData;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ScopeEnum getScopeEnum() {
        return this.registration.getScopeEnum();
    }

    @Override
    public void unregister() {
        if (this.isEnabled()) {
            super.unregister();
            this.worker.schedule(new TaskEvent(this));
        }
    }

    @Override
    public SubscriberRegister assembly() {
        SubscriberRegister register;
        this.readLock.lock();
        try {
            if (null == this.registration.getScopeEnum()) {
                this.registration.setScopeEnum(ScopeEnum.zone);
            }
            register = new SubscriberRegister();
            register.setInstanceId(this.config.getInstanceId());
            if (StringUtils.isNotEmpty(this.config.getZone())) {
                register.setZone(this.config.getZone());
            } else {
                register.setZone("DEFAULT_ZONE");
            }
            if (StringUtils.isNotEmpty(this.registration.getAppName())) {
                register.setAppName(this.registration.getAppName());
            } else {
                register.setAppName(this.config.getAppName());
            }
            register.setDataId(this.registration.getDataId());
            register.setGroup(this.registration.getGroup());
            register.setRegistId(this.REGIST_ID);
            register.setVersion(this.getPubVersion().get());
            register.setTimestamp(this.getTimestamp());
            register.setScope(this.registration.getScopeEnum().name());
            this.setAuthSignature(register);
            if (this.isEnabled()) {
                register.setEventType("REGISTER");
            } else {
                register.setEventType("UNREGISTER");
            }
        }
        finally {
            this.readLock.unlock();
        }
        return register;
    }

    public void putReceivedData(SegmentData segmentData, String localZone) {
        this.writeLock.lock();
        try {
            this.putSegmentData(segmentData);
            this.localZone = localZone;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void putSegmentData(SegmentData segmentData) {
        if (null != segmentData) {
            SegmentData existsData = this.data.putIfAbsent(segmentData.getSegment(), segmentData);
            if (null == existsData) {
                this.init.compareAndSet(false, true);
                return;
            }
            if (existsData.getVersion() < segmentData.getVersion()) {
                boolean result = this.data.replace(segmentData.getSegment(), existsData, segmentData);
                if (!result) {
                    this.putSegmentData(segmentData);
                }
                this.init.compareAndSet(false, true);
            }
        }
    }

    @Override
    public String getDataId() {
        return this.registration.getDataId();
    }

    @Override
    public String getGroup() {
        return this.registration.getGroup();
    }

    @Override
    public String getRegistId() {
        return this.REGIST_ID;
    }

    public List<String> getAvailableSegments() {
        this.readLock.lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.availableSegments);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setAvailableSegments(List<String> availableSegments) {
        this.writeLock.lock();
        try {
            this.availableSegments = null == availableSegments ? new ArrayList<String>() : new ArrayList<String>(availableSegments);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String toString() {
        return "DefaultSubscriber{registration=" + this.registration + '}' + super.toString();
    }
}

