/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.internal;

import com.alipay.sofa.jraft.util.internal.IntegerFieldUpdater;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class UnsafeIntegerFieldUpdater<U>
implements IntegerFieldUpdater<U> {
    private final long offset;
    private final Unsafe unsafe;

    UnsafeIntegerFieldUpdater(Unsafe unsafe, Class<? super U> tClass, String fieldName) throws NoSuchFieldException {
        Field field = tClass.getDeclaredField(fieldName);
        if (unsafe == null) {
            throw new NullPointerException("unsafe");
        }
        this.unsafe = unsafe;
        this.offset = unsafe.objectFieldOffset(field);
    }

    @Override
    public void set(U obj, int newValue) {
        this.unsafe.putInt(obj, this.offset, newValue);
    }

    @Override
    public int get(U obj) {
        return this.unsafe.getInt(obj, this.offset);
    }
}

