/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util.internal;

import com.alipay.sofa.jraft.util.internal.ReferenceFieldUpdater;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import com.alipay.sofa.jraft.util.internal.Updaters;

public final class ThrowUtil {
    private static final ReferenceFieldUpdater<Throwable, Throwable> causeUpdater = Updaters.newReferenceFieldUpdater(Throwable.class, "cause");

    public static void throwException(Throwable t) {
        if (UnsafeUtil.hasUnsafe()) {
            UnsafeUtil.throwException(t);
        } else {
            ThrowUtil.throwException0(t);
        }
    }

    private static <E extends Throwable> void throwException0(Throwable t) throws E {
        throw t;
    }

    public static <T extends Throwable> T cutCause(T cause) {
        Object rootCause = cause;
        while (((Throwable)rootCause).getCause() != null) {
            rootCause = ((Throwable)rootCause).getCause();
        }
        if (rootCause != cause) {
            cause.setStackTrace(((Throwable)rootCause).getStackTrace());
            causeUpdater.set(cause, (Throwable)rootCause);
        }
        return cause;
    }

    public static Throwable getRootCause(Throwable cause) {
        Throwable rootCause = cause;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    private ThrowUtil() {
    }
}

