/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.local;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotMetaTable;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotStorage;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSnapshotWriter
extends SnapshotWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSnapshotWriter.class);
    private final LocalSnapshotMetaTable metaTable;
    private final String path;
    private final LocalSnapshotStorage snapshotStorage;
    private volatile boolean closed;

    public LocalSnapshotWriter(String path, LocalSnapshotStorage snapshotStorage, RaftOptions raftOptions) {
        this.snapshotStorage = snapshotStorage;
        this.path = path;
        this.metaTable = new LocalSnapshotMetaTable(raftOptions);
        this.closed = false;
    }

    @Override
    public boolean init(Void v) {
        File dir = new File(this.path);
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            LOG.error("Fail to create directory {}.", (Object)this.path, (Object)e);
            this.setError(RaftError.EIO, "Fail to create directory  %s", this.path);
            return false;
        }
        String metaPath = this.path + File.separator + "__raft_snapshot_meta";
        File metaFile = new File(metaPath);
        try {
            if (metaFile.exists()) {
                return this.metaTable.loadFromFile(metaPath);
            }
        }
        catch (IOException e) {
            LOG.error("Fail to load snapshot meta from {}.", (Object)metaPath, (Object)e);
            this.setError(RaftError.EIO, "Fail to load snapshot meta from %s", metaPath);
            return false;
        }
        return true;
    }

    public long getSnapshotIndex() {
        return this.metaTable.hasMeta() ? this.metaTable.getMeta().getLastIncludedIndex() : 0L;
    }

    @Override
    public void shutdown() {
        Utils.closeQuietly(this);
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    @Override
    public void close(boolean keepDataOnError) throws IOException {
        this.checkState();
        this.snapshotStorage.close(this, keepDataOnError);
        this.closed = true;
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException("Writer was closed");
        }
    }

    @Override
    public boolean saveMeta(RaftOutter.SnapshotMeta meta) {
        this.checkState();
        this.metaTable.setMeta(meta);
        return true;
    }

    public boolean sync() throws IOException {
        this.checkState();
        return this.metaTable.saveToFile(this.path + File.separator + "__raft_snapshot_meta");
    }

    @Override
    public boolean addFile(String fileName, Message fileMeta) {
        this.checkState();
        LocalFileMetaOutter.LocalFileMeta.Builder metaBuilder = LocalFileMetaOutter.LocalFileMeta.newBuilder();
        if (fileMeta != null) {
            metaBuilder.mergeFrom(fileMeta);
        }
        LocalFileMetaOutter.LocalFileMeta meta = metaBuilder.build();
        return this.metaTable.addFile(fileName, meta);
    }

    @Override
    public boolean removeFile(String fileName) {
        this.checkState();
        return this.metaTable.removeFile(fileName);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<String> listFiles() {
        return this.metaTable.listFiles();
    }

    @Override
    public Message getFileMeta(String fileName) {
        return this.metaTable.getFileMeta(fileName);
    }
}

