/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.local;

import com.alipay.sofa.jraft.entity.RaftOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.RaftOptions;
import com.alipay.sofa.jraft.storage.FileService;
import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotMetaTable;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotStorage;
import com.alipay.sofa.jraft.storage.snapshot.local.SnapshotFileReader;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSnapshotReader
extends SnapshotReader {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSnapshotReader.class);
    private long readerId;
    private final Endpoint addr;
    private final LocalSnapshotMetaTable metaTable;
    private final String path;
    private final LocalSnapshotStorage snapshotStorage;
    private final SnapshotThrottle snapshotThrottle;
    private volatile boolean closed;

    @Override
    public void close() throws IOException {
        this.checkState();
        this.snapshotStorage.unref(this.getSnapshotIndex());
        this.destroyReaderInFileService();
        this.closed = true;
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException("Reader was closed");
        }
    }

    public LocalSnapshotReader(LocalSnapshotStorage snapshotStorage, SnapshotThrottle snapshotThrottle, Endpoint addr, RaftOptions raftOptions, String path) {
        this.snapshotStorage = snapshotStorage;
        this.snapshotThrottle = snapshotThrottle;
        this.addr = addr;
        this.path = path;
        this.readerId = 0L;
        this.closed = false;
        this.metaTable = new LocalSnapshotMetaTable(raftOptions);
    }

    @OnlyForTest
    long getReaderId() {
        return this.readerId;
    }

    @Override
    public boolean init(Void v) {
        File dir = new File(this.path);
        if (!dir.exists()) {
            LOG.error("No such path {} for snapshot reader.", (Object)this.path);
            this.setError(RaftError.ENOENT, "No such path %s for snapshot reader", this.path);
            return false;
        }
        String metaPath = this.path + File.separator + "__raft_snapshot_meta";
        try {
            return this.metaTable.loadFromFile(metaPath);
        }
        catch (IOException e) {
            LOG.error("Fail to load snapshot meta {}.", (Object)metaPath, (Object)e);
            this.setError(RaftError.EIO, "Fail to load snapshot meta from path %s", metaPath);
            return false;
        }
    }

    private long getSnapshotIndex() {
        File file = new File(this.path);
        String name = file.getName();
        if (!name.startsWith("snapshot_")) {
            throw new IllegalStateException("Invalid snapshot path name:" + name);
        }
        return Long.parseLong(name.substring("snapshot_".length()));
    }

    @Override
    public void shutdown() {
        Utils.closeQuietly(this);
    }

    @Override
    public RaftOutter.SnapshotMeta load() {
        if (this.metaTable.hasMeta()) {
            return this.metaTable.getMeta();
        }
        return null;
    }

    @Override
    public String generateURIForCopy() {
        this.checkState();
        if (this.addr == null || this.addr.equals(new Endpoint("0.0.0.0", 0))) {
            LOG.error("Address is not specified");
            return null;
        }
        if (this.readerId == 0L) {
            SnapshotFileReader reader = new SnapshotFileReader(this.path, this.snapshotThrottle);
            reader.setMetaTable(this.metaTable);
            if (!reader.open()) {
                LOG.error("Open snapshot {} failed.", (Object)this.path);
                return null;
            }
            this.readerId = FileService.getInstance().addReader(reader);
            if (this.readerId < 0L) {
                LOG.error("Fail to add reader to file_service.");
                return null;
            }
        }
        return String.format("remote://%s/%d", this.addr, this.readerId);
    }

    private void destroyReaderInFileService() {
        if (this.readerId > 0L) {
            FileService.getInstance().removeReader(this.readerId);
            this.readerId = 0L;
        } else if (this.readerId != 0L) {
            LOG.warn("Ignore destroy invalid readerId: {}", (Object)this.readerId);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<String> listFiles() {
        return this.metaTable.listFiles();
    }

    @Override
    public Message getFileMeta(String fileName) {
        return this.metaTable.getFileMeta(fileName);
    }
}

